/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xplot.h"

void do_blowup (FL_OBJECT *ob, long d)
{
    char
	title [80];
    
    /* create the blowup form */
    create_form_blowup ();		/* blowup is now the form */
					/* blowup_quit is now quitbutton */
                                        /* blowup_plot is now xyplot */

    /* add the form to our list */
    if (! (blowups = (Blowup *) realloc (blowups, 
           (nblowups + 1) * sizeof (Blowup)))
       )
	error ("out of memory");
    blowups [nblowups].form = blowup;
    blowups [nblowups].ob = blowup_plot;
    blowups [nblowups].type = (int) d;

    /* modify the callback */
    fl_set_object_callback (blowup_quit, quitblowup, (long) nblowups);

    /* draw the functions */
    redraw (blowup_plot, blowup);

    if (titlestring [0])		/* overall plotting title? */ 
	showform (blowup, FL_PLACE_FREE, titlestring);
    else				/* our own title */
    {
	sprintf (title, "XPlot blowup %d", nblowups);
	showform (blowup, FL_PLACE_FREE, title);
    }

    nblowups++;                         /* increase # of blowups counter */
    
    blowup = NULL;                      /* allow re-creation the next time */
}
