/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleMappingExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public final class PathExpression
extends Expression
implements ContextMappingFunction {
    private Expression start;
    private Expression step;
    private transient int state = 0;

    public PathExpression(Expression start, Expression step) {
        this.setStartExpression(start);
        this.setStepExpression(step);
        if (step instanceof PathExpression) {
            PathExpression stepPath = (PathExpression)step;
            if (PathExpression.isFilteredAxisPath(stepPath.start) && PathExpression.isFilteredAxisPath(stepPath.step)) {
                this.setStartExpression(new PathExpression(start, stepPath.start));
                this.setStepExpression(stepPath.step);
            }
        }
    }

    private void setStartExpression(Expression start2) {
        if (this.start != start2) {
            this.start = start2;
            this.adoptChildExpression(this.start);
        }
    }

    private void setStepExpression(Expression step2) {
        if (this.step != step2) {
            this.step = step2;
            this.adoptChildExpression(this.step);
        }
    }

    public Expression getStartExpression() {
        return this.start;
    }

    public Expression getStepExpression() {
        return this.step;
    }

    private static boolean isFilteredAxisPath(Expression exp) {
        if (exp instanceof AxisExpression) {
            return true;
        }
        while (exp instanceof FilterExpression) {
            exp = ((FilterExpression)exp).getBaseExpression();
        }
        return exp instanceof AxisExpression;
    }

    public final ItemType getItemType(TypeHierarchy th) {
        return this.step.getItemType(th);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.state > 0) {
            return this;
        }
        this.state = 1;
        this.setStartExpression(visitor.simplify(this.start));
        this.setStepExpression(visitor.simplify(this.step));
        if (Literal.isEmptySequence(this.start)) {
            return this.start;
        }
        if (Literal.isEmptySequence(this.step)) {
            return this.step;
        }
        if (this.start instanceof ContextItemExpression && (this.step instanceof PathExpression || (this.step.getSpecialProperties() & 0x20000) != 0)) {
            return this.step;
        }
        if (this.step instanceof ContextItemExpression && (this.start instanceof PathExpression || (this.start.getSpecialProperties() & 0x20000) != 0)) {
            return this.start;
        }
        if (this.start instanceof RootExpression && this.step instanceof ParentNodeExpression) {
            return Literal.makeEmptySequence();
        }
        return this;
    }

    private PathExpression simplifyDescendantPath(StaticContext env) {
        Expression st = this.start;
        if (this.start instanceof AxisExpression) {
            AxisExpression stax = (AxisExpression)this.start;
            if (stax.getAxis() != 5) {
                return null;
            }
            ContextItemExpression cie = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, cie);
            st = new PathExpression(cie, stax);
            ExpressionTool.copyLocationInfo(this, st);
        }
        if (!(st instanceof PathExpression)) {
            return null;
        }
        PathExpression startPath = (PathExpression)st;
        if (!(startPath.step instanceof AxisExpression)) {
            return null;
        }
        AxisExpression mid = (AxisExpression)startPath.step;
        if (mid.getAxis() != 5) {
            return null;
        }
        NodeTest test = mid.getNodeTest();
        if (test != null && !(test instanceof AnyNodeTest)) {
            return null;
        }
        Expression underlyingStep = this.step;
        while (underlyingStep instanceof FilterExpression) {
            if (((FilterExpression)underlyingStep).isPositional(env.getConfiguration().getTypeHierarchy())) {
                return null;
            }
            underlyingStep = ((FilterExpression)underlyingStep).getBaseExpression();
        }
        if (!(underlyingStep instanceof AxisExpression)) {
            return null;
        }
        AxisExpression underlyingAxis = (AxisExpression)underlyingStep;
        if (underlyingAxis.getAxis() == 3) {
            Expression newStep = new AxisExpression(4, ((AxisExpression)underlyingStep).getNodeTest());
            ExpressionTool.copyLocationInfo(this, newStep);
            underlyingStep = this.step;
            while (underlyingStep instanceof FilterExpression) {
                newStep = new FilterExpression(newStep, ((FilterExpression)underlyingStep).getFilter());
                ExpressionTool.copyLocationInfo(underlyingStep, newStep);
                underlyingStep = ((FilterExpression)underlyingStep).getBaseExpression();
            }
            PathExpression newPath = new PathExpression(startPath.start, newStep);
            ExpressionTool.copyLocationInfo(this, newPath);
            return newPath;
        }
        if (underlyingAxis.getAxis() == 2) {
            AxisExpression newStep = new AxisExpression(5, NodeKindTest.ELEMENT);
            ExpressionTool.copyLocationInfo(this, newStep);
            PathExpression newPath = new PathExpression(new PathExpression(startPath.start, newStep), this.step);
            ExpressionTool.copyLocationInfo(this, newPath);
            return newPath;
        }
        return null;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.state >= 2) {
            this.setStartExpression(visitor.typeCheck(this.start, contextItemType));
            this.setStepExpression(visitor.typeCheck(this.step, this.start.getItemType(th)));
            return this;
        }
        this.state = 2;
        this.setStartExpression(visitor.typeCheck(this.start, contextItemType));
        RoleLocator role0 = new RoleLocator(1, "/", 0, null);
        role0.setSourceLocator(this);
        role0.setErrorCode("XPTY0019");
        this.setStartExpression(TypeChecker.staticTypeCheck(this.start, SequenceType.NODE_SEQUENCE, false, role0, visitor));
        this.setStepExpression(visitor.typeCheck(this.step, this.start.getItemType(th)));
        ItemType stepType = this.step.getItemType(th);
        if (th.isSubType(stepType, Type.NODE_TYPE)) {
            int props;
            if ((this.step.getSpecialProperties() & 0x400000) != 0) {
                Optimizer opt = visitor.getConfiguration().getOptimizer();
                this.setStartExpression(ExpressionTool.unsorted(opt, this.start, false));
                this.setStepExpression(ExpressionTool.unsorted(opt, this.step, false));
                PathExpression p = this.simplifyDescendantPath(visitor.getStaticContext());
                if (p != null) {
                    ExpressionTool.copyLocationInfo(this, p);
                    return visitor.typeCheck(visitor.simplify(p), contextItemType);
                }
                this.adoptChildExpression(this.start);
                this.adoptChildExpression(this.step);
            }
            if (((props = this.getSpecialProperties()) & 0x20000) != 0) {
                return this;
            }
            if ((props & 0x40000) != 0) {
                return SystemFunction.makeSystemFunction("reverse", new Expression[]{this});
            }
            return new DocumentSorter(this);
        }
        if (stepType.isAtomicType()) {
            SimpleMappingExpression sme = new SimpleMappingExpression(this.start, this.step, false);
            ExpressionTool.copyLocationInfo(this, sme);
            return visitor.typeCheck(visitor.simplify(sme), contextItemType);
        }
        SimpleMappingExpression sme = new SimpleMappingExpression(this.start, this.step, true);
        ExpressionTool.copyLocationInfo(this, sme);
        return visitor.typeCheck(visitor.simplify(sme), contextItemType);
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.state >= 3) {
            this.setStartExpression(visitor.optimize(this.start, contextItemType));
            this.setStepExpression(this.step.optimize(visitor, this.start.getItemType(th)));
            return this;
        }
        this.state = 3;
        Expression lastStep = this.getLastStep();
        if (lastStep instanceof FilterExpression && !((FilterExpression)lastStep).isPositional(th)) {
            Expression leading = this.getLeadingSteps();
            PathExpression p2 = new PathExpression(leading, ((FilterExpression)lastStep).getBaseExpression());
            FilterExpression f2 = new FilterExpression(p2, ((FilterExpression)lastStep).getFilter());
            return ((Expression)f2).optimize(visitor, contextItemType);
        }
        Expression k = opt.convertPathExpressionToKey(this, visitor);
        if (k != null) {
            return k.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
        }
        this.setStartExpression(visitor.optimize(this.start, contextItemType));
        this.setStepExpression(this.step.optimize(visitor, this.start.getItemType(th)));
        PromotionOffer offer = new PromotionOffer(opt);
        offer.action = 10;
        offer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        offer.containingExpression = this;
        this.setStepExpression(this.doPromotion(this.step, offer));
        visitor.resetStaticProperties();
        if (offer.containingExpression != this) {
            this.state = 0;
            offer.containingExpression = visitor.optimize(visitor.typeCheck(offer.containingExpression, contextItemType), contextItemType);
            return offer.containingExpression;
        }
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Optimizer optimizer;
        FilterExpression p2;
        PathExpression p = this;
        if (offer.action == 11 && (p2 = (optimizer = offer.getOptimizer()).convertToFilterExpression(this, optimizer.getConfiguration().getTypeHierarchy())) != null) {
            return p2.promote(offer);
        }
        Expression exp = offer.accept(p);
        if (exp != null) {
            return exp;
        }
        this.setStartExpression(this.doPromotion(this.start, offer));
        if (offer.action == 12 || offer.action == 14) {
            this.setStepExpression(this.doPromotion(this.step, offer));
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.step);
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.step;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.start == original) {
            this.setStartExpression(replacement);
            found = true;
        }
        if (this.step == original) {
            this.setStepExpression(replacement);
            found = true;
        }
        return found;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x3E1;
    }

    public Expression copy() {
        return new PathExpression(this.start.copy(), this.step.copy());
    }

    public int computeSpecialProperties() {
        int startProperties = this.start.getSpecialProperties();
        int stepProperties = this.step.getSpecialProperties();
        int p = 0;
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            startProperties |= 0xA0000;
        }
        if (!Cardinality.allowsMany(this.step.getCardinality())) {
            stepProperties |= 0xA0000;
        }
        if ((startProperties & stepProperties & 0x10000) != 0) {
            p |= 0x10000;
        }
        if ((startProperties & 0x800000) != 0 && (stepProperties & 0x10000) != 0) {
            p |= 0x800000;
        }
        if ((startProperties & stepProperties & 0x80000) != 0) {
            p |= 0x80000;
        }
        if ((startProperties & stepProperties & 0x100000) != 0) {
            p |= 0x100000;
        }
        if (this.testNaturallySorted(startProperties, stepProperties)) {
            p |= 0x20000;
        }
        if (this.testNaturallyReverseSorted()) {
            p |= 0x40000;
        }
        if ((startProperties & stepProperties & 0x400000) != 0) {
            p |= 0x400000;
        }
        return p;
    }

    private boolean testNaturallySorted(int startProperties, int stepProperties) {
        if ((stepProperties & 0x20000) == 0) {
            return false;
        }
        if (Cardinality.allowsMany(this.start.getCardinality())) {
            if ((startProperties & 0x20000) == 0) {
                return false;
            }
        } else {
            return true;
        }
        if ((stepProperties & 0x200000) != 0) {
            return true;
        }
        return (startProperties & 0x80000) != 0 && (stepProperties & 0x100000) != 0;
    }

    private boolean testNaturallyReverseSorted() {
        if (!Cardinality.allowsMany(this.start.getCardinality()) && this.step instanceof AxisExpression) {
            return Axis.isReverse[((AxisExpression)this.step).getAxis()];
        }
        if (!(this.start instanceof AxisExpression)) {
            return false;
        }
        if (Axis.isForwards[((AxisExpression)this.start).getAxis()]) {
            return false;
        }
        return false;
    }

    public int computeCardinality() {
        int c1 = this.start.getCardinality();
        int c2 = this.step.getCardinality();
        return Cardinality.multiply(c1, c2);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PathExpression)) {
            return false;
        }
        PathExpression p = (PathExpression)other;
        return this.start.equals(p.start) && this.step.equals(p.step);
    }

    public int hashCode() {
        return "PathExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    public Expression getFirstStep() {
        if (this.start instanceof PathExpression) {
            return ((PathExpression)this.start).getFirstStep();
        }
        return this.start;
    }

    public Expression getRemainingSteps() {
        if (this.start instanceof PathExpression) {
            PathExpression rem = new PathExpression(((PathExpression)this.start).getRemainingSteps(), this.step);
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.step;
    }

    public Expression getLastStep() {
        if (this.step instanceof PathExpression) {
            return ((PathExpression)this.step).getLastStep();
        }
        return this.step;
    }

    public Expression getLeadingSteps() {
        if (this.step instanceof PathExpression) {
            PathExpression rem = new PathExpression(this.start, ((PathExpression)this.step).getLeadingSteps());
            ExpressionTool.copyLocationInfo(this.start, rem);
            return rem;
        }
        return this.start;
    }

    public boolean isAbsolute(TypeHierarchy th) {
        Expression first = this.getFirstStep();
        return first.getItemType(th).getPrimitiveType() == 9;
    }

    public PathExpression tryToMakeAbsolute(TypeHierarchy th) {
        Expression first = this.getFirstStep();
        if (first.getItemType(th).getPrimitiveType() == 9) {
            return this;
        }
        if (first instanceof AxisExpression && ((AxisExpression)first).getContextItemType().getPrimitiveType() == 9) {
            RootExpression root = new RootExpression();
            ExpressionTool.copyLocationInfo(this, root);
            PathExpression path = new PathExpression(root, this);
            ExpressionTool.copyLocationInfo(this, path);
            return path;
        }
        return null;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.start.addToPathMap(pathMap, pathMapNodeSet);
        return this.step.addToPathMap(pathMap, target);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator master = this.start.iterate(context);
        XPathContextMinor context2 = context.newMinorContext();
        context2.setCurrentIterator(master);
        context2.setOriginatingConstructType(2025);
        return new ContextMappingIterator(this, context2);
    }

    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.step.iterate(context);
    }

    public String toString() {
        return "(" + this.start.toString() + "/" + this.step.toString() + ")";
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("path");
        this.start.explain(destination);
        this.step.explain(destination);
        destination.endElement();
    }
}

