/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Literal
extends Expression {
    private Value value;

    public Literal(Value value) {
        this.value = value;
    }

    public static Literal makeLiteral(Value value) {
        if (value instanceof StringValue) {
            return new StringLiteral((StringValue)value);
        }
        return new Literal(value);
    }

    public static Literal makeEmptySequence() {
        return new Literal(EmptySequence.getInstance());
    }

    public Value getValue() {
        return this.value;
    }

    public final Expression simplify(ExpressionVisitor visitor) {
        try {
            this.value = this.value.reduce();
        }
        catch (XPathException err) {
            throw new AssertionError();
        }
        return this;
    }

    public final Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    public final Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) {
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.value.getItemType(th);
    }

    public int computeCardinality() {
        if (this.value instanceof EmptySequence) {
            return 8192;
        }
        if (this.value instanceof AtomicValue) {
            return 16384;
        }
        try {
            SequenceIterator iter = this.value.iterate();
            Item next = iter.next();
            if (next == null) {
                return 8192;
            }
            if (iter.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err) {
            return 57344;
        }
    }

    public int computeSpecialProperties() {
        if (this.getValue() instanceof EmptySequence) {
            return 0xFF0000;
        }
        return 0x400000;
    }

    public Expression copy() {
        return new Literal(this.value);
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMapNodeSet;
    }

    public final int getDependencies() {
        return 0;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.value.iterate();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.value instanceof AtomicValue) {
            return (AtomicValue)this.value;
        }
        return this.value.iterate().next();
    }

    public void process(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator iter = this.value.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append(it, 0, 2);
        }
    }

    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.evaluateItem(context);
        if (value == null) {
            return "";
        }
        return value.getStringValueCS();
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.value.effectiveBooleanValue();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Literal)) {
            return false;
        }
        Value v = ((Literal)obj).value;
        return this.value.getSchemaComparable().equals(v.getSchemaComparable());
    }

    public int hashCode() {
        return this.value.getSchemaComparable().hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("literal");
        if (this.value instanceof EmptySequence) {
            out.emitAttribute("value", "()");
        } else if (this.value instanceof AtomicValue) {
            out.emitAttribute("value", ((AtomicValue)this.value).getStringValue());
            out.emitAttribute("type", ((AtomicValue)this.value).getTypeLabel().getDisplayName());
        } else {
            try {
                out.emitAttribute("count", this.value.getLength() + "");
                if (this.value.getLength() < 20) {
                    Item it;
                    SequenceIterator iter = this.iterate(null);
                    while ((it = iter.next()) != null) {
                        if (it instanceof NodeInfo) {
                            out.startElement("node");
                            out.emitAttribute("path", Navigator.getPath((NodeInfo)it));
                            out.emitAttribute("uri", ((NodeInfo)it).getSystemId());
                            out.endElement();
                            continue;
                        }
                        out.startElement("atomicValue");
                        out.emitAttribute("value", it.getStringValue());
                        out.emitAttribute("type", ((AtomicValue)it).getTypeLabel().getDisplayName());
                        out.endElement();
                    }
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        out.endElement();
    }

    public static boolean isAtomic(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue;
    }

    public static boolean isEmptySequence(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue() instanceof EmptySequence;
    }

    public static boolean isConstantBoolean(Expression exp, boolean value) {
        if (exp instanceof Literal) {
            Value b = ((Literal)exp).getValue();
            return b instanceof BooleanValue && ((BooleanValue)b).getBooleanValue() == value;
        }
        return false;
    }

    public static boolean isConstantOne(Expression exp) {
        if (exp instanceof Literal) {
            Value v = ((Literal)exp).getValue();
            return v instanceof Int64Value && ((Int64Value)v).longValue() == 1L;
        }
        return false;
    }
}

