#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <locale.h>
#include <signal.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "mdns.h"
#include "apps.h"
#include "vnc.h"

/* ------------------------------------------------------------------ */

static Display   *dpy;
static struct mdns_window *mdns;

static char             *service = "_ssh._tcp";
static char             *domain  = NULL;
static enum mdns_view   view = MDNS_VIEW_DEFAULT;
static mdns_callback    callback = NULL;

/* ------------------------------------------------------------------ */

static void usage(FILE *fp)
{
    fprintf(fp,
	    "This is a mDNS browser\n"
	    "\n"
	    "usage: mdns-browser [options]\n"
	    "options:\n"
	    "   -h            print this text\n"
	    "   -s <service>  specify service [%s]\n"
	    "   -d <domain>   specify domain\n"
	    "   -u            url mode, displays a different set of default\n"
	    "                 columns, useful for _http._tcp & friends.\n"
	    "   -x            xen mode, yet another default column set, this\n"
	    "                 also sets service to _xendom._tcp\n"
	    "   -r            vnc mode, sets service to _rfb._tcp\n"
	    "   -w            sets service to _workstation._tcp\n"
	    "\n"
	    "-- \n"
	    "(c) 2006 Gerd Hoffmann <kraxel@redhat.com>\n",
	    service);
}

static void vnc_callback(struct mdns_window *mdns, char *name, char *type,
			 char *host, int port, char *url)
{
    vnc_open(host, port, VNC_FLAG_SHOW_MOUSE, 0);
}

int
main(int argc, char *argv[])
{
    int c;

    gtk_init(&argc, &argv);
    for (;;) {
        if (-1 == (c = getopt(argc, argv, "huxrws:d:")))
            break;
        switch (c) {
        case 's':
	    service = optarg;
            break;
        case 'd':
	    domain = optarg;
            break;
	case 'u':
	    view = MDNS_VIEW_URL;
	    break;
	case 'x':
	    service = "_xendom._tcp";
	    view = MDNS_VIEW_XEN;
	    break;
	case 'r':
	    service = "_rfb._tcp";
	    break;
	case 'w':
	    service = "_workstation._tcp";
	    break;
        case 'h':
            usage(stdout);
            exit(0);
        default:
            usage(stderr);
            exit(1);
        }
    }

    dpy = gdk_x11_display_get_xdisplay(gdk_display_get_default());
    fcntl(ConnectionNumber(dpy),F_SETFD,FD_CLOEXEC);
    detect_desktop();

#ifdef HAVE_GTK_VNC
    if (0 == strcmp(service, "_rfb._tcp"))
	callback = vnc_callback;
#endif
    
    mdns = mdns_create_window(1, view, callback);
    if (NULL == mdns) {
	fprintf(stderr,"Oops: mDNS did't initialize ok\n");
	exit(1);
    }
    mdns_show_window(mdns);
    mdns_browse(mdns, 1, service, domain);
    if (0)
	mdns_browse(mdns, 0, "_workstation._tcp", NULL);

    gtk_main();
    fprintf(stderr,"bye...\n");
    exit(0);
}
