/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.ConditionalExpression;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.StandardFunction;
import edu.hws.jcm.data.Variable;

public class ExpressionProgram
implements Expression {
    public static final int PLUS = -1;
    public static final int MINUS = -2;
    public static final int TIMES = -3;
    public static final int DIVIDE = -4;
    public static final int POWER = -5;
    public static final int EQ = -6;
    public static final int NE = -7;
    public static final int LT = -8;
    public static final int GT = -9;
    public static final int LE = -10;
    public static final int GE = -11;
    public static final int AND = -12;
    public static final int OR = -13;
    public static final int NOT = -14;
    public static final int UNARY_MINUS = -15;
    public static final int FACTORIAL = -16;
    public static final int SIN = -17;
    public static final int COS = -18;
    public static final int TAN = -19;
    public static final int COT = -20;
    public static final int SEC = -21;
    public static final int CSC = -22;
    public static final int ARCSIN = -23;
    public static final int ARCCOS = -24;
    public static final int ARCTAN = -25;
    public static final int ABS = -26;
    public static final int SQRT = -27;
    public static final int EXP = -28;
    public static final int LN = -29;
    public static final int LOG2 = -30;
    public static final int LOG10 = -31;
    public static final int TRUNC = -32;
    public static final int ROUND = -33;
    public static final int FLOOR = -34;
    public static final int CEILING = -35;
    public static final int CUBERT = -36;
    public String sourceString;
    private int[] prog = new int[1];
    private int progCt;
    private Cases cases;
    private StackOfDouble stack = new StackOfDouble();
    private double[] constant = new double[1];
    private int constantCt;
    private ExpressionCommand[] command = new ExpressionCommand[1];
    private int commandCt;

    public void addCommandObject(ExpressionCommand expressionCommand) {
        int n = this.findCommand(expressionCommand);
        this.addCommandCode(n + 0x3FFFFFFF);
    }

    public void addConstant(double d) {
        int n = this.findConstant(d);
        this.addCommandCode(n);
    }

    public void addCommand(int n) {
        if (n >= 0 || n < -36) {
            throw new IllegalArgumentException("Internal Error.  Illegal command code.");
        }
        this.addCommandCode(n);
    }

    public void trim() {
        Object[] objectArray;
        if (this.progCt != this.prog.length) {
            objectArray = new int[this.progCt];
            System.arraycopy(this.prog, 0, objectArray, 0, this.progCt);
            this.prog = objectArray;
        }
        if (this.commandCt != this.command.length) {
            objectArray = new ExpressionCommand[this.commandCt];
            System.arraycopy(this.command, 0, objectArray, 0, this.commandCt);
            this.command = (ExpressionCommand[])objectArray;
        }
        if (this.constantCt != this.constant.length) {
            objectArray = new double[this.constantCt];
            System.arraycopy(this.constant, 0, objectArray, 0, this.constantCt);
            this.constant = objectArray;
        }
    }

    private void addCommandCode(int n) {
        if (this.progCt == this.prog.length) {
            int[] nArray = new int[this.prog.length * 2];
            System.arraycopy(this.prog, 0, nArray, 0, this.progCt);
            this.prog = nArray;
        }
        this.prog[this.progCt++] = n;
    }

    @Override
    public synchronized double getVal() {
        this.cases = null;
        return this.basicGetValue();
    }

    @Override
    public synchronized double getValueWithCases(Cases cases) {
        this.cases = cases;
        double d = this.basicGetValue();
        this.cases = null;
        return d;
    }

    private double basicGetValue() {
        this.stack.makeEmpty();
        for (int i = 0; i < this.progCt; ++i) {
            int n = this.prog[i];
            if (n < 0) {
                double d = this.applyCommandCode(n);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    if (this.cases != null) {
                        this.cases.addCase(0);
                    }
                    return Double.NaN;
                }
                this.stack.push(d);
                continue;
            }
            if (n < 0x3FFFFFFF) {
                this.stack.push(this.constant[n]);
                continue;
            }
            this.command[n - 0x3FFFFFFF].apply(this.stack, this.cases);
        }
        if (this.stack.size() != 1) {
            throw new IllegalArgumentException("Internal Error:  Improper stack state after expression evaluation.");
        }
        double d = this.stack.pop();
        if (this.cases != null) {
            this.cases.addCase(Double.isNaN(d) ? 0 : 1);
        }
        return d;
    }

    private void addCase(int n) {
        if (this.cases != null) {
            this.cases.addCase(n);
        }
    }

    protected double applyCommandCode(int n) {
        double d = n < -13 ? this.eval(n, this.stack.pop()) : this.eval(n, this.stack.pop(), this.stack.pop());
        return d;
    }

    private double eval(int n, double d) {
        switch (n) {
            case -14: {
                return d == 0.0 ? 1.0 : 0.0;
            }
            case -15: {
                return -d;
            }
            case -16: {
                return this.factorial(d);
            }
            case -17: {
                return Math.sin(d);
            }
            case -18: {
                return Math.cos(d);
            }
            case -19: {
                this.addCase((int)Math.floor((d - 1.5707963267948966) / Math.PI));
                return Math.tan(d);
            }
            case -20: {
                this.addCase((int)Math.floor(d / Math.PI));
                return Math.cos(d) / Math.sin(d);
            }
            case -21: {
                this.addCase((int)Math.floor((d - 1.5707963267948966) / Math.PI));
                return 1.0 / Math.cos(d);
            }
            case -22: {
                this.addCase((int)Math.floor(d / Math.PI));
                return 1.0 / Math.sin(d);
            }
            case -23: {
                return Math.asin(d);
            }
            case -24: {
                return Math.acos(d);
            }
            case -25: {
                return Math.atan(d);
            }
            case -26: {
                this.addCase(d > 0.0 ? 1 : (d < 0.0 ? -1 : 0));
                return Math.abs(d);
            }
            case -27: {
                return d < 0.0 ? Double.NaN : Math.sqrt(d);
            }
            case -28: {
                return Math.exp(d);
            }
            case -29: {
                return d <= 0.0 ? Double.NaN : Math.log(d);
            }
            case -30: {
                return d <= 0.0 ? Double.NaN : Math.log(d) / Math.log(2.0);
            }
            case -31: {
                return d <= 0.0 ? Double.NaN : Math.log(d) / Math.log(10.0);
            }
            case -32: {
                this.addCase((int)d);
                return (long)d;
            }
            case -33: {
                this.addCase((int)Math.floor(d + 0.5));
                return Math.floor(d + 0.5);
            }
            case -34: {
                this.addCase((int)Math.floor(d));
                return Math.floor(d);
            }
            case -35: {
                this.addCase((int)Math.floor(d));
                return Math.ceil(d);
            }
            case -36: {
                this.addCase(d > 0.0 ? 1 : -1);
                return d >= 0.0 ? Math.pow(d, 0.3333333333333333) : -Math.pow(-d, 0.3333333333333333);
            }
        }
        return Double.NaN;
    }

    private double factorial(double d) {
        if (d <= -0.5 || d > 170.5) {
            this.addCase(-1);
            return Double.NaN;
        }
        int n = (int)d;
        this.addCase(n);
        double d2 = 1.0;
        for (int i = 1; i <= n; ++i) {
            d2 *= (double)i;
        }
        return d2;
    }

    private double eval(int n, double d, double d2) {
        switch (n) {
            case -1: {
                return d2 + d;
            }
            case -2: {
                return d2 - d;
            }
            case -3: {
                return d2 * d;
            }
            case -4: {
                this.addCase(d > 0.0 ? 1 : (d < 0.0 ? -1 : 0));
                return d2 / d;
            }
            case -5: {
                return Math.pow(d2, d);
            }
            case -6: {
                return d2 == d ? 1.0 : 0.0;
            }
            case -7: {
                return d2 != d ? 1.0 : 0.0;
            }
            case -9: {
                return d2 > d ? 1.0 : 0.0;
            }
            case -8: {
                return d2 < d ? 1.0 : 0.0;
            }
            case -11: {
                return d2 >= d ? 1.0 : 0.0;
            }
            case -10: {
                return d2 <= d ? 1.0 : 0.0;
            }
            case -12: {
                return d2 != 0.0 && d != 0.0 ? 1.0 : 0.0;
            }
            case -13: {
                return d2 != 0.0 || d != 0.0 ? 1.0 : 0.0;
            }
        }
        return Double.NaN;
    }

    @Override
    public String toString() {
        if (this.sourceString != null) {
            return this.sourceString;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendOutputString(this.progCt - 1, stringBuffer);
        return stringBuffer.toString();
    }

    public void appendOutputString(int n, StringBuffer stringBuffer) {
        if (this.prog[n] >= 0x3FFFFFFF) {
            this.command[this.prog[n] - 0x3FFFFFFF].appendOutputString(this, n, stringBuffer);
        } else if (this.prog[n] >= 0) {
            stringBuffer.append(NumUtils.realToString(this.constant[this.prog[n]]));
        } else if (this.prog[n] >= -13) {
            int n2 = n - 1;
            int n3 = n2 - this.extent(n2);
            if (this.precedence(this.prog[n3]) < this.precedence(this.prog[n]) || this.prog[n] == -5 && this.precedence(this.prog[n3]) == this.precedence(this.prog[n])) {
                stringBuffer.append('(');
                this.appendOutputString(n3, stringBuffer);
                stringBuffer.append(')');
            } else {
                this.appendOutputString(n3, stringBuffer);
            }
            switch (this.prog[n]) {
                case -1: {
                    stringBuffer.append(" + ");
                    break;
                }
                case -2: {
                    stringBuffer.append(" - ");
                    break;
                }
                case -3: {
                    stringBuffer.append("*");
                    break;
                }
                case -4: {
                    stringBuffer.append("/");
                    break;
                }
                case -5: {
                    stringBuffer.append("^");
                    break;
                }
                case -12: {
                    stringBuffer.append(" AND ");
                    break;
                }
                case -13: {
                    stringBuffer.append(" OR ");
                    break;
                }
                case -6: {
                    stringBuffer.append(" = ");
                    break;
                }
                case -7: {
                    stringBuffer.append(" <> ");
                    break;
                }
                case -11: {
                    stringBuffer.append(" >= ");
                    break;
                }
                case -10: {
                    stringBuffer.append(" <= ");
                    break;
                }
                case -9: {
                    stringBuffer.append(" > ");
                    break;
                }
                case -8: {
                    stringBuffer.append(" < ");
                }
            }
            if (this.prog[n2] == -15 || this.precedence(this.prog[n2]) < this.precedence(this.prog[n]) || (this.prog[n] == -2 || this.prog[n] == -4) && this.precedence(this.prog[n2]) == this.precedence(this.prog[n])) {
                stringBuffer.append('(');
                this.appendOutputString(n2, stringBuffer);
                stringBuffer.append(')');
            } else {
                this.appendOutputString(n2, stringBuffer);
            }
        } else if (this.prog[n] <= -17) {
            stringBuffer.append(StandardFunction.standardFunctionName(this.prog[n]));
            stringBuffer.append('(');
            this.appendOutputString(n - 1, stringBuffer);
            stringBuffer.append(')');
        } else if (this.prog[n] == -15) {
            stringBuffer.append('-');
            if (this.precedence(this.prog[n - 1]) <= this.precedence(-15)) {
                stringBuffer.append('(');
                this.appendOutputString(n - 1, stringBuffer);
                stringBuffer.append(')');
            } else {
                this.appendOutputString(n - 1, stringBuffer);
            }
        } else if (this.prog[n] == -14) {
            stringBuffer.append("NOT (");
            this.appendOutputString(n - 1, stringBuffer);
            stringBuffer.append(')');
        } else if (this.prog[n] == -16) {
            if (this.prog[n - 1] >= 0 && (this.prog[n - 1] < 0x3FFFFFFF || this.command[this.prog[n - 1] - 0x3FFFFFFF] instanceof Variable || this.command[this.prog[n - 1] - 0x3FFFFFFF] instanceof Constant)) {
                this.appendOutputString(n - 1, stringBuffer);
            } else {
                stringBuffer.append('(');
                this.appendOutputString(n - 1, stringBuffer);
                stringBuffer.append(')');
            }
            stringBuffer.append('!');
        }
    }

    private int precedence(int n) {
        if (n >= 0) {
            if (n >= 0x3FFFFFFF && this.command[n - 0x3FFFFFFF] instanceof ConditionalExpression) {
                return 0;
            }
            return 7;
        }
        switch (n) {
            case -16: 
            case -13: 
            case -12: {
                return 1;
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: {
                return 2;
            }
            case -15: 
            case -2: 
            case -1: {
                return 3;
            }
            case -4: 
            case -3: {
                return 4;
            }
            case -5: {
                return 6;
            }
        }
        return 7;
    }

    @Override
    public Expression derivative(Variable variable) {
        ExpressionProgram expressionProgram = new ExpressionProgram();
        this.compileDerivative(this.progCt - 1, expressionProgram, variable);
        expressionProgram.trim();
        return expressionProgram;
    }

    public void compileDerivative(int n, ExpressionProgram expressionProgram, Variable variable) {
        if (!this.dependsOn(n, variable)) {
            expressionProgram.addConstant(0.0);
        } else if (this.prog[n] >= 0x3FFFFFFF) {
            this.command[this.prog[n] - 0x3FFFFFFF].compileDerivative(this, n, expressionProgram, variable);
        } else if (this.prog[n] >= 0) {
            expressionProgram.addConstant(0.0);
        } else if (this.prog[n] >= -5) {
            int n2 = n - 1;
            int n3 = n2 - this.extent(n2);
            this.doBinDeriv(this.prog[n], n3, n2, expressionProgram, variable);
        } else if (this.prog[n] <= -17) {
            this.doFuncDeriv(this.prog[n], n - 1, expressionProgram, variable);
        } else if (this.prog[n] == -15) {
            this.compileDerivative(n - 1, expressionProgram, variable);
            expressionProgram.addCommand(-15);
        } else if (this.prog[n] == -16) {
            expressionProgram.addConstant(Double.NaN);
        } else {
            if (this.prog[n] >= -14) {
                throw new IllegalArgumentException("Internal Error: Attempt to take the derivative of a logical-valued expression.");
            }
            throw new IllegalArgumentException("Internal Error: Unknown opcode.");
        }
    }

    public int extent(int n) {
        if (this.prog[n] <= -14) {
            return 1 + this.extent(n - 1);
        }
        if (this.prog[n] < 0) {
            int n2 = this.extent(n - 1);
            int n3 = this.extent(n - 1 - n2);
            return n2 + n3 + 1;
        }
        if (this.prog[n] < 0x3FFFFFFF) {
            return 1;
        }
        return this.command[this.prog[n] - 0x3FFFFFFF].extent(this, n);
    }

    public void copyExpression(int n, ExpressionProgram expressionProgram) {
        int n2 = this.extent(n);
        for (int i = n - n2 + 1; i <= n; ++i) {
            if (this.prog[i] < 0) {
                expressionProgram.addCommand(this.prog[i]);
                continue;
            }
            if (this.prog[i] >= 0x3FFFFFFF) {
                expressionProgram.addCommandObject(this.command[this.prog[i] - 0x3FFFFFFF]);
                continue;
            }
            expressionProgram.addConstant(this.constant[this.prog[i]]);
        }
    }

    public boolean dependsOn(int n, Variable variable) {
        int n2 = this.extent(n);
        for (int i = n - n2 + 1; i <= n; ++i) {
            ExpressionCommand expressionCommand;
            if (this.prog[i] < 0x3FFFFFFF || (expressionCommand = this.command[this.prog[i] - 0x3FFFFFFF]) != variable && !expressionCommand.dependsOn(variable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOn(Variable variable) {
        return this.dependsOn(this.progCt - 1, variable);
    }

    private void doBinDeriv(int n, int n2, int n3, ExpressionProgram expressionProgram, Variable variable) {
        switch (n) {
            case -1: {
                if (!this.dependsOn(n2, variable)) {
                    this.compileDerivative(n3, expressionProgram, variable);
                    break;
                }
                if (!this.dependsOn(n3, variable)) {
                    this.compileDerivative(n2, expressionProgram, variable);
                    break;
                }
                this.compileDerivative(n2, expressionProgram, variable);
                this.compileDerivative(n3, expressionProgram, variable);
                expressionProgram.addCommand(-1);
                break;
            }
            case -2: {
                if (!this.dependsOn(n2, variable)) {
                    this.compileDerivative(n3, expressionProgram, variable);
                    expressionProgram.addCommand(-15);
                    break;
                }
                if (!this.dependsOn(n3, variable)) {
                    this.compileDerivative(n2, expressionProgram, variable);
                    break;
                }
                this.compileDerivative(n2, expressionProgram, variable);
                this.compileDerivative(n3, expressionProgram, variable);
                expressionProgram.addCommand(-2);
                break;
            }
            case -3: {
                int n4 = 0;
                if (this.dependsOn(n3, variable)) {
                    this.copyExpression(n2, expressionProgram);
                    if (this.prog[n3] < 0x3FFFFFFF || this.command[this.prog[n3] - 0x3FFFFFFF] != variable) {
                        this.compileDerivative(n3, expressionProgram, variable);
                        expressionProgram.addCommand(-3);
                    }
                    ++n4;
                }
                if (this.dependsOn(n2, variable)) {
                    this.copyExpression(n3, expressionProgram);
                    if (this.prog[n2] < 0x3FFFFFFF || this.command[this.prog[n2] - 0x3FFFFFFF] != variable) {
                        this.compileDerivative(n2, expressionProgram, variable);
                        expressionProgram.addCommand(-3);
                    }
                    ++n4;
                }
                if (n4 != 2) break;
                expressionProgram.addCommand(-1);
                break;
            }
            case -4: {
                if (!this.dependsOn(n3, variable)) {
                    this.compileDerivative(n2, expressionProgram, variable);
                    this.copyExpression(n3, expressionProgram);
                    expressionProgram.addCommand(-4);
                    break;
                }
                if (!this.dependsOn(n2, variable)) {
                    this.copyExpression(n2, expressionProgram);
                    expressionProgram.addCommand(-15);
                    this.copyExpression(n3, expressionProgram);
                    expressionProgram.addConstant(2.0);
                    expressionProgram.addCommand(-5);
                    expressionProgram.addCommand(-4);
                    if (this.prog[n3] >= 0x3FFFFFFF && this.command[this.prog[n3] - 0x3FFFFFFF] == variable) break;
                    this.compileDerivative(n3, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                    break;
                }
                this.copyExpression(n3, expressionProgram);
                if (this.prog[n2] < 0x3FFFFFFF || this.command[this.prog[n2] - 0x3FFFFFFF] != variable) {
                    this.compileDerivative(n2, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                }
                this.copyExpression(n2, expressionProgram);
                if (this.prog[n3] < 0x3FFFFFFF || this.command[this.prog[n3] - 0x3FFFFFFF] != variable) {
                    this.compileDerivative(n3, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                }
                expressionProgram.addCommand(-2);
                this.copyExpression(n3, expressionProgram);
                expressionProgram.addConstant(2.0);
                expressionProgram.addCommand(-5);
                expressionProgram.addCommand(-4);
                break;
            }
            case -5: {
                if (!this.dependsOn(n3, variable)) {
                    this.copyExpression(n3, expressionProgram);
                    this.copyExpression(n2, expressionProgram);
                    if (this.prog[n3] >= 0 && this.prog[n3] < 0x3FFFFFFF) {
                        if (this.constant[this.prog[n3]] != 2.0) {
                            expressionProgram.addConstant(this.constant[this.prog[n3]] - 1.0);
                            expressionProgram.addCommand(-5);
                        }
                    } else if (this.prog[n3] == -15 && this.prog[n3 - 1] >= 0 && this.prog[n3 - 1] < 0x3FFFFFFF) {
                        expressionProgram.addConstant(this.constant[this.prog[n3 - 1]] + 1.0);
                        expressionProgram.addCommand(-15);
                        expressionProgram.addCommand(-5);
                    } else {
                        this.copyExpression(n3, expressionProgram);
                        expressionProgram.addConstant(1.0);
                        expressionProgram.addCommand(-2);
                        expressionProgram.addCommand(-5);
                    }
                    expressionProgram.addCommand(-3);
                    if (this.prog[n2] >= 0x3FFFFFFF && this.command[this.prog[n2] - 0x3FFFFFFF] == variable) break;
                    this.compileDerivative(n2, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                    break;
                }
                if (!this.dependsOn(n2, variable)) {
                    this.copyExpression(n2, expressionProgram);
                    this.copyExpression(n3, expressionProgram);
                    expressionProgram.addCommand(-5);
                    if (this.prog[n2] < 0x3FFFFFFF || !(this.command[this.prog[n2] - 0x3FFFFFFF] instanceof Constant) || ((Constant)this.command[this.prog[n2] - 0x3FFFFFFF]).getVal() != Math.E) {
                        this.copyExpression(n2, expressionProgram);
                        expressionProgram.addCommand(-29);
                        expressionProgram.addCommand(-3);
                    }
                    if (this.prog[n3] >= 0x3FFFFFFF && this.command[this.prog[n3] - 0x3FFFFFFF] == variable) break;
                    this.compileDerivative(n3, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                    break;
                }
                this.copyExpression(n2, expressionProgram);
                this.copyExpression(n3, expressionProgram);
                expressionProgram.addCommand(-5);
                boolean bl = true;
                int n5 = this.extent(n2);
                int n6 = this.extent(n3);
                if (n5 != n6) {
                    bl = false;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        if (this.prog[n2 - i] == this.prog[n3 - i]) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    expressionProgram.addConstant(1.0);
                } else {
                    this.copyExpression(n3, expressionProgram);
                    this.copyExpression(n2, expressionProgram);
                    expressionProgram.addCommand(-4);
                }
                if (this.prog[n2] < 0x3FFFFFFF || this.command[this.prog[n2] - 0x3FFFFFFF] != variable) {
                    this.compileDerivative(n2, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                }
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-29);
                if (this.prog[n3] < 0x3FFFFFFF || this.command[this.prog[n3] - 0x3FFFFFFF] != variable) {
                    this.compileDerivative(n3, expressionProgram, variable);
                    expressionProgram.addCommand(-3);
                }
                expressionProgram.addCommand(-1);
                expressionProgram.addCommand(-3);
            }
        }
    }

    private void doFuncDeriv(int n, int n2, ExpressionProgram expressionProgram, Variable variable) {
        switch (n) {
            case -35: 
            case -34: 
            case -33: 
            case -32: {
                this.copyExpression(n2, expressionProgram);
                if (n == -33) {
                    expressionProgram.addConstant(0.5);
                    expressionProgram.addCommand(-1);
                }
                expressionProgram.addCommand(-33);
                this.copyExpression(n2, expressionProgram);
                if (n == -33) {
                    expressionProgram.addConstant(0.5);
                    expressionProgram.addCommand(-1);
                }
                expressionProgram.addCommand(-7);
                if (n == -32) {
                    this.copyExpression(n2, expressionProgram);
                    expressionProgram.addConstant(0.0);
                    expressionProgram.addCommand(-6);
                    expressionProgram.addCommand(-13);
                }
                ExpressionProgram expressionProgram2 = new ExpressionProgram();
                expressionProgram2.addConstant(0.0);
                expressionProgram.addCommandObject(new ConditionalExpression(expressionProgram2, null));
                return;
            }
            case -17: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-18);
                break;
            }
            case -18: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-17);
                expressionProgram.addCommand(-15);
                break;
            }
            case -19: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-21);
                expressionProgram.addConstant(2.0);
                expressionProgram.addCommand(-5);
                break;
            }
            case -20: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-22);
                expressionProgram.addConstant(2.0);
                expressionProgram.addCommand(-5);
                expressionProgram.addCommand(-15);
                break;
            }
            case -21: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-21);
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-19);
                expressionProgram.addCommand(-3);
                break;
            }
            case -22: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-22);
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-20);
                expressionProgram.addCommand(-3);
                expressionProgram.addCommand(-15);
                break;
            }
            case -24: 
            case -23: {
                expressionProgram.addConstant(1.0);
                if (n == -24) {
                    expressionProgram.addCommand(-15);
                }
                expressionProgram.addConstant(1.0);
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addConstant(2.0);
                expressionProgram.addCommand(-5);
                expressionProgram.addCommand(-2);
                expressionProgram.addCommand(-27);
                expressionProgram.addCommand(-4);
                break;
            }
            case -25: {
                expressionProgram.addConstant(1.0);
                expressionProgram.addConstant(1.0);
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addConstant(2.0);
                expressionProgram.addCommand(-5);
                expressionProgram.addCommand(-1);
                expressionProgram.addCommand(-4);
                break;
            }
            case -26: {
                ExpressionProgram expressionProgram3 = new ExpressionProgram();
                ExpressionProgram expressionProgram4 = new ExpressionProgram();
                this.compileDerivative(n2, expressionProgram3, variable);
                this.compileDerivative(n2, expressionProgram4, variable);
                expressionProgram4.addCommand(-15);
                ExpressionProgram expressionProgram5 = new ExpressionProgram();
                this.copyExpression(n2, expressionProgram5);
                expressionProgram5.addConstant(0.0);
                expressionProgram5.addCommand(-8);
                expressionProgram5.addCommandObject(new ConditionalExpression(expressionProgram4, null));
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addConstant(0.0);
                expressionProgram.addCommand(-9);
                expressionProgram.addCommandObject(new ConditionalExpression(expressionProgram3, expressionProgram5));
                return;
            }
            case -27: {
                expressionProgram.addConstant(1.0);
                expressionProgram.addConstant(2.0);
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-27);
                expressionProgram.addCommand(-3);
                expressionProgram.addCommand(-4);
                break;
            }
            case -28: {
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addCommand(-28);
                break;
            }
            case -31: 
            case -30: 
            case -29: {
                ExpressionProgram expressionProgram6 = new ExpressionProgram();
                expressionProgram6.addConstant(1.0);
                this.copyExpression(n2, expressionProgram6);
                expressionProgram6.addCommand(-4);
                if (n != -29) {
                    expressionProgram6.addConstant(n == -30 ? 2.0 : 10.0);
                    expressionProgram6.addCommand(-29);
                    expressionProgram6.addCommand(-4);
                }
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addConstant(0.0);
                expressionProgram.addCommand(-9);
                expressionProgram.addCommandObject(new ConditionalExpression(expressionProgram6, null));
                break;
            }
            case -36: {
                expressionProgram.addConstant(1.0);
                expressionProgram.addConstant(3.0);
                this.copyExpression(n2, expressionProgram);
                expressionProgram.addConstant(2.0);
                expressionProgram.addCommand(-5);
                expressionProgram.addCommand(-36);
                expressionProgram.addCommand(-3);
                expressionProgram.addCommand(-4);
            }
        }
        if (this.prog[n2] < 0x3FFFFFFF || this.command[this.prog[n2] - 0x3FFFFFFF] != variable) {
            this.compileDerivative(n2, expressionProgram, variable);
            expressionProgram.addCommand(-3);
        }
    }

    private int findConstant(double d) {
        for (int i = 0; i < this.constantCt; ++i) {
            if (this.constant[i] != d) continue;
            return i;
        }
        if (this.constantCt == this.constant.length) {
            double[] dArray = new double[this.constant.length * 2];
            System.arraycopy(this.constant, 0, dArray, 0, this.constantCt);
            this.constant = dArray;
        }
        this.constant[this.constantCt++] = d;
        return this.constantCt - 1;
    }

    private int findCommand(ExpressionCommand expressionCommand) {
        for (int i = 0; i < this.commandCt; ++i) {
            if (this.command[i] != expressionCommand) continue;
            return i;
        }
        if (this.commandCt == this.command.length) {
            ExpressionCommand[] expressionCommandArray = new ExpressionCommand[this.command.length * 2];
            System.arraycopy(this.command, 0, expressionCommandArray, 0, this.commandCt);
            this.command = expressionCommandArray;
        }
        this.command[this.commandCt++] = expressionCommand;
        return this.commandCt - 1;
    }
}

