/*
 * Decompiled with CFR 0.152.
 */
package benchmarks;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class JuliaPanel
extends JPanel {
    double dx = 4.0;
    double dy = 4.0;
    double cr = 0.0;
    double cc = 0.0;
    int maxiters;
    double maxlength = 30.0;
    boolean init = false;
    BufferedImage image;

    public void run() {
        this.image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.maxiters = 1000;
        int iters = 0;
        double out = this.maxlength * this.maxlength;
        int maxiter = 0;
        double len = 0.0;
        double maxlen = 0.0;
        for (int j = 0; j < this.getHeight(); ++j) {
            double c = this.dy / 2.0 - this.dy * (double)j / (double)this.getHeight();
            for (int i = 0; i < this.getWidth(); ++i) {
                double r;
                double tr = r = this.dx * (double)i / (double)this.getWidth() - this.dx / 2.0;
                double tc = c;
                iters = 0;
                for (int k = 0; k < this.maxiters; ++k) {
                    tr = tr * tr - tc * tc + this.cr;
                    tc = 2.0 * tr * tc + this.cc;
                    ++iters;
                    len = tr * tr + tc * tc;
                    if (len > maxlen) {
                        maxlen = len;
                    }
                    if (len > out) break;
                }
                if (iters > maxiter) {
                    maxiter = iters;
                }
                this.image.setRGB(i, j, Color.HSBtoRGB((float)((double)iters * 1.0 / (double)this.maxiters), 1.0f, 1.0f));
            }
        }
        System.err.println("max iter " + maxiter);
        System.err.println("max len " + maxlen);
    }

    public void paint(Graphics g) {
        if (!this.init) {
            this.run();
            this.init = true;
        }
        g.drawImage(this.image, 0, 0, null);
    }
}

