/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;
typedef struct _ValaInitializerListPrivate ValaInitializerListPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_UNARY_OPERATOR (vala_unary_operator_get_type ())

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
};

struct _ValaInitializerList {
	ValaExpression parent_instance;
	ValaInitializerListPrivate * priv;
};

struct _ValaInitializerListClass {
	ValaExpressionClass parent_class;
};

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

typedef enum  {
	VALA_UNARY_OPERATOR_NONE,
	VALA_UNARY_OPERATOR_PLUS,
	VALA_UNARY_OPERATOR_MINUS,
	VALA_UNARY_OPERATOR_LOGICAL_NEGATION,
	VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT,
	VALA_UNARY_OPERATOR_INCREMENT,
	VALA_UNARY_OPERATOR_DECREMENT,
	VALA_UNARY_OPERATOR_REF,
	VALA_UNARY_OPERATOR_OUT
} ValaUnaryOperator;


static gpointer vala_initializer_list_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_initializer_list_get_type (void) G_GNUC_CONST;
#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
enum  {
	VALA_INITIALIZER_LIST_DUMMY_PROPERTY
};
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_initializer_list_get_initializers (ValaInitializerList* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference);
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference);
ValaExpression* vala_expression_construct (GType object_type);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_initializer_list (ValaCodeVisitor* self, ValaInitializerList* list);
void vala_code_visitor_visit_expression (ValaCodeVisitor* self, ValaExpression* expr);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
gboolean vala_expression_is_constant (ValaExpression* self);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
gboolean vala_expression_is_pure (ValaExpression* self);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
GType vala_reference_type_get_type (void) G_GNUC_CONST;
GType vala_array_type_get_type (void) G_GNUC_CONST;
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
GType vala_array_creation_expression_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
gint vala_array_type_get_rank (ValaArrayType* self);
ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
void vala_array_type_set_rank (ValaArrayType* self, gint value);
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
GType vala_struct_get_type (void) G_GNUC_CONST;
ValaStruct* vala_struct_get_base_struct (ValaStruct* self);
GType vala_field_get_type (void) G_GNUC_CONST;
ValaList* vala_struct_get_fields (ValaStruct* self);
gchar* vala_code_node_to_string (ValaCodeNode* self);
GType vala_member_binding_get_type (void) G_GNUC_CONST;
ValaMemberBinding vala_field_get_binding (ValaField* self);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
gboolean vala_data_type_get_value_owned (ValaDataType* self);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GType vala_unary_expression_get_type (void) G_GNUC_CONST;
GType vala_unary_operator_get_type (void) G_GNUC_CONST;
ValaUnaryOperator vala_unary_expression_get_operator (ValaUnaryExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
void vala_data_type_set_nullable (ValaDataType* self, gboolean value);
static void vala_initializer_list_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
void vala_code_node_emit (ValaCodeNode* self, ValaCodeGenerator* codegen);
gint vala_initializer_list_get_size (ValaInitializerList* self);
static void vala_initializer_list_finalize (ValaCodeNode* obj);


/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void vala_initializer_list_append (ValaInitializerList* self, ValaExpression* expr) {
	ValaList* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = expr;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = expr;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_initializer_list_get_initializers (ValaInitializerList* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList* vala_initializer_list_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaInitializerList* self = NULL;
	ValaSourceReference* _tmp0_;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	return self;
}


ValaInitializerList* vala_initializer_list_new (ValaSourceReference* source_reference) {
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void vala_initializer_list_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _expr_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_size;
		gint _expr_index;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaExpression* expr;
			ValaExpression* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void vala_initializer_list_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaInitializerList * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_initializer_list (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static gboolean vala_initializer_list_real_is_constant (ValaExpression* base) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _initializer_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_size;
		gint _initializer_index;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaExpression* initializer;
			ValaExpression* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			_tmp12_ = vala_expression_is_constant (_tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean vala_initializer_list_real_is_pure (ValaExpression* base) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _initializer_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_size;
		gint _initializer_index;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaExpression* initializer;
			ValaExpression* _tmp11_;
			gboolean _tmp12_ = FALSE;
			_tmp5_ = _initializer_index;
			_initializer_index = _tmp5_ + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = initializer;
			_tmp12_ = vala_expression_is_pure (_tmp11_);
			if (!_tmp12_) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static void vala_initializer_list_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				ValaList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_ = NULL;
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				gboolean _tmp12_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->initializers;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->initializers;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				_tmp10_ = (ValaExpression*) _tmp9_;
				_tmp11_ = old_node;
				_tmp12_ = _tmp10_ == _tmp11_;
				_vala_code_node_unref0 (_tmp10_);
				if (_tmp12_) {
					ValaList* _tmp13_;
					gint _tmp14_;
					ValaExpression* _tmp15_;
					_tmp13_ = self->priv->initializers;
					_tmp14_ = i;
					_tmp15_ = new_node;
					vala_list_set (_tmp13_, _tmp14_, _tmp15_);
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_initializer_list_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _error_;
	gboolean _tmp206_;
	gboolean _tmp213_;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		if (VALA_IS_ARRAY_TYPE (_tmp9_)) {
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			ValaArrayType* _tmp12_;
			ValaArrayType* array_type;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			ValaCodeNode* _tmp15_;
			ValaCodeNode* _tmp16_;
			gboolean _tmp19_;
			gboolean _tmp22_;
			ValaDataType* inner_target_type = NULL;
			ValaArrayType* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (VALA_ARRAY_TYPE (_tmp11_));
			array_type = _tmp12_;
			_tmp15_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp16_ = _tmp15_;
			if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp16_)) {
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				_tmp17_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				_tmp14_ = !VALA_IS_CONSTANT (_tmp18_);
			} else {
				_tmp14_ = FALSE;
			}
			_tmp19_ = _tmp14_;
			if (_tmp19_) {
				ValaCodeNode* _tmp20_;
				ValaCodeNode* _tmp21_;
				_tmp20_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp21_ = _tmp20_;
				_tmp13_ = !VALA_IS_INITIALIZER_LIST (_tmp21_);
			} else {
				_tmp13_ = FALSE;
			}
			_tmp22_ = _tmp13_;
			if (_tmp22_) {
				ValaCodeNode* _tmp23_;
				ValaCodeNode* _tmp24_;
				ValaCodeNode* _tmp25_;
				ValaCodeNode* old_parent_node;
				ValaArrayType* _tmp26_;
				ValaDataType* _tmp27_;
				ValaDataType* _tmp28_;
				ValaDataType* _tmp29_ = NULL;
				ValaDataType* _tmp30_;
				ValaArrayType* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaArrayCreationExpression* _tmp36_;
				ValaArrayCreationExpression* _tmp37_;
				ValaArrayCreationExpression* array_creation;
				ValaArrayCreationExpression* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaCodeNode* _tmp41_;
				ValaArrayCreationExpression* _tmp42_;
				ValaArrayCreationExpression* _tmp43_;
				ValaCodeContext* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp23_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = _vala_code_node_ref0 (_tmp24_);
				old_parent_node = _tmp25_;
				_tmp26_ = array_type;
				_tmp27_ = vala_array_type_get_element_type (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_data_type_copy (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = array_type;
				_tmp32_ = vala_array_type_get_rank (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_array_creation_expression_new (_tmp30_, _tmp33_, self, _tmp35_);
				_tmp37_ = _tmp36_;
				_vala_code_node_unref0 (_tmp30_);
				array_creation = _tmp37_;
				_tmp38_ = array_creation;
				_tmp39_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp40_ = _tmp39_;
				vala_expression_set_target_type ((ValaExpression*) _tmp38_, _tmp40_);
				_tmp41_ = old_parent_node;
				_tmp42_ = array_creation;
				vala_code_node_replace_expression (_tmp41_, (ValaExpression*) self, (ValaExpression*) _tmp42_);
				vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
				_tmp43_ = array_creation;
				_tmp44_ = context;
				_tmp45_ = vala_code_node_check ((ValaCodeNode*) _tmp43_, _tmp44_);
				result = _tmp45_;
				_vala_code_node_unref0 (array_creation);
				_vala_code_node_unref0 (old_parent_node);
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp46_ = array_type;
			_tmp47_ = vala_array_type_get_rank (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_ > 1) {
				ValaArrayType* _tmp49_;
				ValaDataType* _tmp50_ = NULL;
				ValaArrayType* inner_array_type;
				ValaArrayType* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				ValaArrayType* _tmp54_;
				ValaDataType* _tmp55_;
				_tmp49_ = array_type;
				_tmp50_ = vala_data_type_copy ((ValaDataType*) _tmp49_);
				inner_array_type = VALA_ARRAY_TYPE (_tmp50_);
				_tmp51_ = inner_array_type;
				_tmp52_ = vala_array_type_get_rank (_tmp51_);
				_tmp53_ = _tmp52_;
				vala_array_type_set_rank (_tmp51_, _tmp53_ - 1);
				_tmp54_ = inner_array_type;
				_tmp55_ = _vala_code_node_ref0 ((ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp55_;
				_vala_code_node_unref0 (inner_array_type);
			} else {
				ValaArrayType* _tmp56_;
				ValaDataType* _tmp57_;
				ValaDataType* _tmp58_;
				ValaDataType* _tmp59_ = NULL;
				_tmp56_ = array_type;
				_tmp57_ = vala_array_type_get_element_type (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_data_type_copy (_tmp58_);
				_vala_code_node_unref0 (inner_target_type);
				inner_target_type = _tmp59_;
			}
			{
				ValaList* _tmp60_ = NULL;
				ValaList* _e_list;
				ValaList* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				gint _e_size;
				gint _e_index;
				_tmp60_ = vala_initializer_list_get_initializers (self);
				_e_list = _tmp60_;
				_tmp61_ = _e_list;
				_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
				_tmp63_ = _tmp62_;
				_e_size = _tmp63_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					ValaList* _tmp67_;
					gint _tmp68_;
					gpointer _tmp69_ = NULL;
					ValaExpression* e;
					ValaExpression* _tmp70_;
					ValaDataType* _tmp71_;
					_tmp64_ = _e_index;
					_e_index = _tmp64_ + 1;
					_tmp65_ = _e_index;
					_tmp66_ = _e_size;
					if (!(_tmp65_ < _tmp66_)) {
						break;
					}
					_tmp67_ = _e_list;
					_tmp68_ = _e_index;
					_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
					e = (ValaExpression*) _tmp69_;
					_tmp70_ = e;
					_tmp71_ = inner_target_type;
					vala_expression_set_target_type (_tmp70_, _tmp71_);
					_vala_code_node_unref0 (e);
				}
				_vala_iterable_unref0 (_e_list);
			}
			_vala_code_node_unref0 (inner_target_type);
			_vala_code_node_unref0 (array_type);
		} else {
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			ValaTypeSymbol* _tmp74_;
			ValaTypeSymbol* _tmp75_;
			_tmp72_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_data_type_get_data_type (_tmp73_);
			_tmp75_ = _tmp74_;
			if (VALA_IS_STRUCT (_tmp75_)) {
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaStruct* _tmp80_;
				ValaStruct* st;
				ValaStruct* _tmp88_;
				ValaList* _tmp89_ = NULL;
				ValaList* _tmp90_;
				ValaIterator* _tmp91_ = NULL;
				ValaIterator* _tmp92_;
				ValaIterator* field_it;
				_tmp76_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_data_type (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = _vala_code_node_ref0 (VALA_STRUCT (_tmp79_));
				st = _tmp80_;
				while (TRUE) {
					ValaStruct* _tmp81_;
					ValaStruct* _tmp82_;
					ValaStruct* _tmp83_;
					ValaStruct* _tmp84_;
					ValaStruct* _tmp85_;
					ValaStruct* _tmp86_;
					ValaStruct* _tmp87_;
					_tmp81_ = st;
					_tmp82_ = vala_struct_get_base_struct (_tmp81_);
					_tmp83_ = _tmp82_;
					if (!(_tmp83_ != NULL)) {
						break;
					}
					_tmp84_ = st;
					_tmp85_ = vala_struct_get_base_struct (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp87_ = _vala_code_node_ref0 (_tmp86_);
					_vala_code_node_unref0 (st);
					st = _tmp87_;
				}
				_tmp88_ = st;
				_tmp89_ = vala_struct_get_fields (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_iterable_iterator ((ValaIterable*) _tmp90_);
				_tmp92_ = _tmp91_;
				_vala_iterable_unref0 (_tmp90_);
				field_it = _tmp92_;
				{
					ValaList* _tmp93_ = NULL;
					ValaList* _e_list;
					ValaList* _tmp94_;
					gint _tmp95_;
					gint _tmp96_;
					gint _e_size;
					gint _e_index;
					_tmp93_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp93_;
					_tmp94_ = _e_list;
					_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
					_tmp96_ = _tmp95_;
					_e_size = _tmp96_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp97_;
						gint _tmp98_;
						gint _tmp99_;
						ValaList* _tmp100_;
						gint _tmp101_;
						gpointer _tmp102_ = NULL;
						ValaExpression* e;
						ValaField* field;
						ValaExpression* _tmp120_;
						ValaField* _tmp121_;
						ValaDataType* _tmp122_;
						ValaDataType* _tmp123_;
						ValaDataType* _tmp124_ = NULL;
						ValaDataType* _tmp125_;
						ValaDataType* _tmp126_;
						ValaDataType* _tmp127_;
						gboolean _tmp128_;
						gboolean _tmp129_;
						_tmp97_ = _e_index;
						_e_index = _tmp97_ + 1;
						_tmp98_ = _e_index;
						_tmp99_ = _e_size;
						if (!(_tmp98_ < _tmp99_)) {
							break;
						}
						_tmp100_ = _e_list;
						_tmp101_ = _e_index;
						_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
						e = (ValaExpression*) _tmp102_;
						field = NULL;
						while (TRUE) {
							ValaField* _tmp103_;
							ValaIterator* _tmp104_;
							gboolean _tmp105_ = FALSE;
							ValaIterator* _tmp115_;
							gpointer _tmp116_ = NULL;
							ValaField* _tmp117_;
							ValaMemberBinding _tmp118_;
							ValaMemberBinding _tmp119_;
							_tmp103_ = field;
							if (!(_tmp103_ == NULL)) {
								break;
							}
							_tmp104_ = field_it;
							_tmp105_ = vala_iterator_next (_tmp104_);
							if (!_tmp105_) {
								ValaExpression* _tmp106_;
								ValaSourceReference* _tmp107_;
								ValaSourceReference* _tmp108_;
								ValaDataType* _tmp109_;
								ValaDataType* _tmp110_;
								gchar* _tmp111_ = NULL;
								gchar* _tmp112_;
								gchar* _tmp113_ = NULL;
								gchar* _tmp114_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp106_ = e;
								_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
								_tmp108_ = _tmp107_;
								_tmp109_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp110_ = _tmp109_;
								_tmp111_ = vala_code_node_to_string ((ValaCodeNode*) _tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp112_);
								_tmp114_ = _tmp113_;
								vala_report_error (_tmp108_, _tmp114_);
								_g_free0 (_tmp114_);
								_g_free0 (_tmp112_);
								result = FALSE;
								_vala_code_node_unref0 (field);
								_vala_code_node_unref0 (e);
								_vala_iterable_unref0 (_e_list);
								_vala_iterator_unref0 (field_it);
								_vala_code_node_unref0 (st);
								return result;
							}
							_tmp115_ = field_it;
							_tmp116_ = vala_iterator_get (_tmp115_);
							_vala_code_node_unref0 (field);
							field = (ValaField*) _tmp116_;
							_tmp117_ = field;
							_tmp118_ = vala_field_get_binding (_tmp117_);
							_tmp119_ = _tmp118_;
							if (_tmp119_ != VALA_MEMBER_BINDING_INSTANCE) {
								_vala_code_node_unref0 (field);
								field = NULL;
							}
						}
						_tmp120_ = e;
						_tmp121_ = field;
						_tmp122_ = vala_variable_get_variable_type ((ValaVariable*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_data_type_copy (_tmp123_);
						_tmp125_ = _tmp124_;
						vala_expression_set_target_type (_tmp120_, _tmp125_);
						_vala_code_node_unref0 (_tmp125_);
						_tmp126_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_data_type_get_value_owned (_tmp127_);
						_tmp129_ = _tmp128_;
						if (!_tmp129_) {
							ValaExpression* _tmp130_;
							ValaDataType* _tmp131_;
							ValaDataType* _tmp132_;
							_tmp130_ = e;
							_tmp131_ = vala_expression_get_target_type (_tmp130_);
							_tmp132_ = _tmp131_;
							vala_data_type_set_value_owned (_tmp132_, FALSE);
						}
						_vala_code_node_unref0 (field);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_iterator_unref0 (field_it);
				_vala_code_node_unref0 (st);
			} else {
				ValaSourceReference* _tmp133_;
				ValaSourceReference* _tmp134_;
				ValaDataType* _tmp135_;
				ValaDataType* _tmp136_;
				gchar* _tmp137_ = NULL;
				gchar* _tmp138_;
				gchar* _tmp139_ = NULL;
				gchar* _tmp140_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp136_ = _tmp135_;
				_tmp137_ = vala_code_node_to_string ((ValaCodeNode*) _tmp136_);
				_tmp138_ = _tmp137_;
				_tmp139_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp138_);
				_tmp140_ = _tmp139_;
				vala_report_error (_tmp134_, _tmp140_);
				_g_free0 (_tmp140_);
				_g_free0 (_tmp138_);
				result = FALSE;
				return result;
			}
		}
	}
	{
		ValaList* _tmp141_;
		ValaList* _tmp142_;
		ValaList* _expr_list;
		ValaList* _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gint _expr_size;
		gint _expr_index;
		_tmp141_ = self->priv->initializers;
		_tmp142_ = _vala_iterable_ref0 (_tmp141_);
		_expr_list = _tmp142_;
		_tmp143_ = _expr_list;
		_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
		_tmp145_ = _tmp144_;
		_expr_size = _tmp145_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp146_;
			gint _tmp147_;
			gint _tmp148_;
			ValaList* _tmp149_;
			gint _tmp150_;
			gpointer _tmp151_ = NULL;
			ValaExpression* expr;
			ValaExpression* _tmp152_;
			ValaCodeContext* _tmp153_;
			_tmp146_ = _expr_index;
			_expr_index = _tmp146_ + 1;
			_tmp147_ = _expr_index;
			_tmp148_ = _expr_size;
			if (!(_tmp147_ < _tmp148_)) {
				break;
			}
			_tmp149_ = _expr_list;
			_tmp150_ = _expr_index;
			_tmp151_ = vala_list_get (_tmp149_, _tmp150_);
			expr = (ValaExpression*) _tmp151_;
			_tmp152_ = expr;
			_tmp153_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp152_, _tmp153_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_error_ = FALSE;
	{
		ValaList* _tmp154_ = NULL;
		ValaList* _e_list;
		ValaList* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gint _e_size;
		gint _e_index;
		_tmp154_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp154_;
		_tmp155_ = _e_list;
		_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
		_tmp157_ = _tmp156_;
		_e_size = _tmp157_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			ValaList* _tmp161_;
			gint _tmp162_;
			gpointer _tmp163_ = NULL;
			ValaExpression* e;
			ValaExpression* _tmp164_;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			ValaExpression* _tmp170_;
			ValaUnaryExpression* _tmp171_;
			ValaUnaryExpression* unary;
			gboolean _tmp172_ = FALSE;
			ValaUnaryExpression* _tmp173_;
			gboolean _tmp182_;
			_tmp158_ = _e_index;
			_e_index = _tmp158_ + 1;
			_tmp159_ = _e_index;
			_tmp160_ = _e_size;
			if (!(_tmp159_ < _tmp160_)) {
				break;
			}
			_tmp161_ = _e_list;
			_tmp162_ = _e_index;
			_tmp163_ = vala_list_get (_tmp161_, _tmp162_);
			e = (ValaExpression*) _tmp163_;
			_tmp164_ = e;
			_tmp165_ = vala_expression_get_value_type (_tmp164_);
			_tmp166_ = _tmp165_;
			if (_tmp166_ == NULL) {
				ValaExpression* _tmp167_;
				ValaSourceReference* _tmp168_;
				ValaSourceReference* _tmp169_;
				_error_ = TRUE;
				_tmp167_ = e;
				_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp167_);
				_tmp169_ = _tmp168_;
				vala_report_error (_tmp169_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp170_ = e;
			_tmp171_ = _vala_code_node_ref0 (VALA_IS_UNARY_EXPRESSION (_tmp170_) ? ((ValaUnaryExpression*) _tmp170_) : NULL);
			unary = _tmp171_;
			_tmp173_ = unary;
			if (_tmp173_ != NULL) {
				gboolean _tmp174_ = FALSE;
				ValaUnaryExpression* _tmp175_;
				ValaUnaryOperator _tmp176_;
				ValaUnaryOperator _tmp177_;
				gboolean _tmp181_;
				_tmp175_ = unary;
				_tmp176_ = vala_unary_expression_get_operator (_tmp175_);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == VALA_UNARY_OPERATOR_REF) {
					_tmp174_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp178_;
					ValaUnaryOperator _tmp179_;
					ValaUnaryOperator _tmp180_;
					_tmp178_ = unary;
					_tmp179_ = vala_unary_expression_get_operator (_tmp178_);
					_tmp180_ = _tmp179_;
					_tmp174_ = _tmp180_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp181_ = _tmp174_;
				_tmp172_ = _tmp181_;
			} else {
				_tmp172_ = FALSE;
			}
			_tmp182_ = _tmp172_;
			if (_tmp182_) {
			} else {
				ValaExpression* _tmp183_;
				ValaDataType* _tmp184_;
				ValaDataType* _tmp185_;
				ValaExpression* _tmp186_;
				ValaDataType* _tmp187_;
				ValaDataType* _tmp188_;
				gboolean _tmp189_ = FALSE;
				_tmp183_ = e;
				_tmp184_ = vala_expression_get_value_type (_tmp183_);
				_tmp185_ = _tmp184_;
				_tmp186_ = e;
				_tmp187_ = vala_expression_get_target_type (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_data_type_compatible (_tmp185_, _tmp188_);
				if (!_tmp189_) {
					ValaExpression* _tmp190_;
					ValaExpression* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaSourceReference* _tmp193_;
					ValaExpression* _tmp194_;
					ValaDataType* _tmp195_;
					ValaDataType* _tmp196_;
					gchar* _tmp197_ = NULL;
					gchar* _tmp198_;
					ValaExpression* _tmp199_;
					ValaDataType* _tmp200_;
					ValaDataType* _tmp201_;
					gchar* _tmp202_ = NULL;
					gchar* _tmp203_;
					gchar* _tmp204_ = NULL;
					gchar* _tmp205_;
					_error_ = TRUE;
					_tmp190_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp190_, TRUE);
					_tmp191_ = e;
					_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp191_);
					_tmp193_ = _tmp192_;
					_tmp194_ = e;
					_tmp195_ = vala_expression_get_target_type (_tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_code_node_to_string ((ValaCodeNode*) _tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = e;
					_tmp200_ = vala_expression_get_value_type (_tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_code_node_to_string ((ValaCodeNode*) _tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp198_, _tmp203_);
					_tmp205_ = _tmp204_;
					vala_report_error (_tmp193_, _tmp205_);
					_g_free0 (_tmp205_);
					_g_free0 (_tmp203_);
					_g_free0 (_tmp198_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp206_ = _error_;
	if (!_tmp206_) {
		ValaDataType* _tmp207_;
		ValaDataType* _tmp208_;
		ValaDataType* _tmp209_ = NULL;
		ValaDataType* _tmp210_;
		ValaDataType* _tmp211_;
		ValaDataType* _tmp212_;
		_tmp207_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp208_ = _tmp207_;
		_tmp209_ = vala_data_type_copy (_tmp208_);
		_tmp210_ = _tmp209_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp210_);
		_vala_code_node_unref0 (_tmp210_);
		_tmp211_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp212_ = _tmp211_;
		vala_data_type_set_nullable (_tmp212_, FALSE);
	}
	_tmp213_ = _error_;
	result = !_tmp213_;
	return result;
}


static void vala_initializer_list_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaInitializerList * self;
	ValaCodeGenerator* _tmp13_;
	ValaCodeGenerator* _tmp14_;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _expr_list;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_size;
		gint _expr_index;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			ValaExpression* expr;
			ValaExpression* _tmp11_;
			ValaCodeGenerator* _tmp12_;
			_tmp5_ = _expr_index;
			_expr_index = _tmp5_ + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = _expr_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			expr = (ValaExpression*) _tmp10_;
			_tmp11_ = expr;
			_tmp12_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp13_ = codegen;
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) _tmp13_, self);
	_tmp14_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp14_, (ValaExpression*) self);
}


gint vala_initializer_list_get_size (ValaInitializerList* self) {
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void vala_initializer_list_class_init (ValaInitializerListClass * klass) {
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_initializer_list_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_initializer_list_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_constant = vala_initializer_list_real_is_constant;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_initializer_list_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_initializer_list_real_replace_expression;
	VALA_CODE_NODE_CLASS (klass)->check = vala_initializer_list_real_check;
	VALA_CODE_NODE_CLASS (klass)->emit = vala_initializer_list_real_emit;
}


static void vala_initializer_list_instance_init (ValaInitializerList * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}


static void vala_initializer_list_finalize (ValaCodeNode* obj) {
	ValaInitializerList * self;
	self = VALA_INITIALIZER_LIST (obj);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


/**
 * Represents an array or struct initializer list in the source code.
 */
GType vala_initializer_list_get_type (void) {
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}



