/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

// Defines the entry point for the console application.
//
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "AMTPPSharedData.h"
#include "AMTPPDefs.h"
#ifdef _WIN32
#include <objbase.h>
#include <process.h>
#include <wincrypt.h>
#endif

#include <string>
#include <stdio.h>
#include <time.h>

#include <stddef.h>
#include "CryptUtils.h"


AMTPPSharedData::AMTPPSharedData(const char * name, bool bOwner /*= false*/, bool bPublic /*= false*/) :
  _name(name),
  m_bOwner(bOwner),
  m_bPublic(bPublic)
{
  _lastError = 0;
}

AMTPPSharedData::~AMTPPSharedData()
{
  if (m_bOwner)
    Remove();
}

bool AMTPPSharedData::Read(unsigned char * buff,unsigned int &length, bool decrypt){
  UNSREG_DATATYPE valueSize;
  UNSREG_DATATYPE type;
  bool res = true;

  //
  //data to read is encrypted
  //
  if(true == decrypt){
    if (true == GetRegistryData(NULL, &valueSize, &type, AMT_PP_REG_BASE,
				AMT_PP_REG_KEY, const_cast<char*>(_name))) {
      if (valueSize > 0) {
	char * decBuf = new char[valueSize];
	char * tmpBuff = NULL;

	if (false == GetRegistryData(decBuf, &valueSize, &type, AMT_PP_REG_BASE,
				     AMT_PP_REG_KEY,const_cast<char*> (_name))) {
#ifdef _WIN32
	  _lastError = GetLastError();
#endif
	  res = false;
	}
	else{
	  if(false == Decrypt(decBuf, (unsigned long*)&valueSize, (void**)&tmpBuff)){
	    res = false;
	  }
	  else{
	    if (buff == NULL || valueSize > length) {
#ifdef _WIN32
	      _lastError = ERROR_BAD_LENGTH;
#endif

	      length = valueSize;
	      res = false;
	    }
	    else{
	      memcpy(buff,tmpBuff,valueSize);
	    }

	    if(NULL != tmpBuff)
#ifdef _WIN32
	      if( NULL != LocalFree(tmpBuff)){
		//could not free memory
	      }
#else
	    delete [] tmpBuff;
#endif
	  }
	}

	delete [] decBuf;
      }
      else{
	//could not read from registry
#ifdef _WIN32
	_lastError = GetLastError();
#endif
	length = 0;
	res=false;
      }
    }
  }
  //
  //data to read is not encrypted
  //
  else{
    if (true == GetRegistryData(NULL, &valueSize, &type, AMT_PP_REG_BASE,
				AMT_PP_REG_KEY, const_cast<char*>(_name))) {
      if (valueSize > 0) {
	if (buff == NULL || valueSize > length) {
	  //_lastError = ERROR_BAD_LENGTH;
	  length = valueSize;
	  res = false;
	}
	else{
	  if (false == GetRegistryData(buff, &valueSize, &type, AMT_PP_REG_BASE,
				       AMT_PP_REG_KEY,const_cast<char*> (_name))) {
	    //_lastError = GetLastError();
	    res = false;
	  }
	}
      }
    }
  }

  return res;
}

bool AMTPPSharedData::Write(const unsigned char *buff,unsigned int length, bool encrypt){

  if(true == encrypt){
    char * encBuf = NULL;
    unsigned long llength = length;
    Encrypt(buff, (unsigned long*)&llength, (void**)&encBuf);
    if (false == SetRegistryData( encBuf, (UNSREG_DATATYPE)llength, REG_BINARY, AMT_PP_REG_BASE, AMT_PP_REG_KEY,
				  const_cast<char*>(_name), m_bPublic)) {
      //_lastError = GetLastError();
      return false;
    }
    if(NULL != encBuf){
#ifdef _WIN32
      if( NULL != LocalFree(encBuf)){
	//could not free memory
      }
#else
      delete [] encBuf;
#endif
    }
  }
  else{
    if(false == SetRegistryData( buff, (UNSREG_DATATYPE)length, REG_BINARY, AMT_PP_REG_BASE, AMT_PP_REG_KEY,
				 const_cast<char*>(_name), m_bPublic)){
      //_lastError = GetLastError();
      return false;
    }

  }


  return true;
}

bool AMTPPSharedData::Remove(){
  if(true == DeleteRegistryVal(AMT_PP_REG_BASE, AMT_PP_REG_KEY,const_cast<char*>(_name))){
    return true;
  }
  return false;

}

void AMTPPSharedData::ReleaseOwnership()
{
  m_bOwner = false;
}

int AMTPPSharedData::LastError(){
  return _lastError;
}


