import extractor
import defcon
# from fontTools.ttLib import TTFont
from ufo2ft import compileOTF

ufo = defcon.Font()

# Take the font generated by FL5 from the VFB and extract it to UFO
extractor.extractUFO("data/ibm_plex/IBM Plex Serif-Text-FL.otf", ufo)

# Save the extracted UFO
ufo.save("data/ibm_plex/IBM Plex Serif-Text-FL_extracted.otf.ufo")
ufo = defcon.Font("data/ibm_plex/IBM Plex Serif-Text-FL_extracted.otf.ufo")

# Build a new TTF from the extracted UFO
ttf = compileOTF(ufo)
ttf.save("data/ibm_plex/IBM Plex Serif-Text-ufo2ft.otf")

# Force recompilation by closing and reopening the font; not needed
# ttf.close()
# ttf = TTFont("data/ibm_plex/IBM Plex Serif-Text-ufo2ft.ttf")

# Also save TTX dump
ttf.saveXML("data/ibm_plex/IBM Plex Serif-Text-ufo2ft.otf.ttx")
ttf.saveXML("data/ibm_plex/IBM Plex Serif-Text-FL.otf.ttx")


# ufo = defcon.Font()
# extractor.extractUFO("data/font_a/font-normal-fl.ttf", ufo)
# ufo.save("data/font_a/font-normal-fl_extracted.ufo")
# ufo = defcon.Font("data/font_a/font-normal-fl_extracted.ufo")
# ttf = compileTTF(ufo)
# ttf.save("data/font_a/font-normal-ufo2ft.ttf")
# ttf.saveXML("data/font_a/font-normal-ufo2ft.ttx")
