/* usertree.c -- Users list maintenance. Users are kept in a binary tree.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"
#include "trees.h"

static BTREE Root = NULL;

static int
DEFUN (user_compare, (user1, user2),
       CONST user_rec_t * user1 AND CONST user_rec_t * user2)
{
  int ret = strcmp (user1->User, user2->User);

  return ret;
}

static PTR
DEFUN (user_new, (data),
       CONST PTR data)
{
  user_rec_t *ur;
  
  ur = (user_rec_t *) xmalloc (sizeof (user_rec_t));
  ur->User = savestring (((CONST user_rec_t *) data)->User);
  ur->Killed = FALSE;
  ur->Commands = NULL;
  ur->Out.Files = 0;
  ur->Out.Bytes = ur->Out.Time = 0.0;
#if TAYLOR_UUCP
  ur->In.Files = 0;
  ur->In.Bytes = ur->In.Time = 0.0;
#endif
  
  return (PTR) ur;
}

user_rec_t *
DEFUN (insert_user, (user),
       CONST char *user)
{
  user_rec_t ur;
  
  if (Root == NULL)
    Root = btree_new ((compare_func_t) user_compare, (makenew_func_t) user_new);

  ur.User = (char *) get_possible_user_alias (user);
  return (user_rec_t *) btree_insert (Root, &ur);
}

void
DEFUN (kill_user, (user),
       CONST char *user)
{
  user_rec_t ur;
  
  if (Root == NULL)
    Root = btree_new ((compare_func_t) user_compare, (makenew_func_t) user_new);

  ur.User = (char *) get_possible_user_alias (user);
  ((user_rec_t *) (btree_insert (Root, &ur)))->Killed = TRUE;
}

static traverse_func_t originalTraverseFunction;

static void
DEFUN (FilteredEnquiry, (user),
       CONST user_rec_t * user)
{
  if (! user->Killed)
    (*originalTraverseFunction) (user);
}

void
DEFUN (enquire_users, (funct),
       traverse_func_t funct)
{
  originalTraverseFunction = funct;
  btree_traverse (Root, (traverse_func_t) FilteredEnquiry);
}

user_rec_t *
DEFUN (search_user, (user),
       CONST char *user)
{
  user_rec_t ur;

  ur.User = (char *) get_possible_user_alias (user);
  return (user_rec_t *) btree_search (Root, &ur);
}

#if USE_TCL

int
DEFUN (tcl_kill_user, (clientData, interp, argc, argv),
       ClientData clientData AND
       Tcl_Interp * interp AND
       int argc AND
       char *argv[])

{
  if (argc != 2)
    {
      sprintf (interp->result, _("Wrong number of Parameters: %s needs just one UserName"), argv[0]);
      return TCL_ERROR;
    }
  kill_user (argv[1]);
  return TCL_OK;
}

#endif /* if USE_TCL */
