% tpm2_checkquote(1) tpm2-tools | General Commands Manual

# NAME

**tpm2_checkquote**(1) - Validates a quote provided by a TPM.

# SYNOPSIS

**tpm2_checkquote** [*OPTIONS*]

# DESCRIPTION

**tpm2_checkquote**(1) - Uses the public portion of the provided key to validate
a quote generated by a TPM. This will validate the signature against the quote
message and, if provided, verify that the qualifying data and PCR values match
those in the quote. The PCR values can be provided with or without the
TPML_PCR_SELECTION information. An example of PCR values without the PCR
selection information is the output from **tpm2_pcrread**. If PCR value is
specified without the PCR selection information, then the PCR selection string
must be specified using the **-l** option to interpret the PCR data.


# OPTIONS

  * **-u**, **\--public**=_FILE_:

    File input for the public portion of the signature verification key. Either the *pem*
    file or *tss* public format file.

  * **-g**, **\--hash-algorithm**=_ALGORITHM_:

    The hash algorithm used to digest the message.

  * **-m**, **\--message**=_FILE_:

    The quote message that makes up the data that is signed by the TPM.

  * **-s**, **\--signature**=_FILE_:

    The input signature file of the signature to be validated.

  * **-f**, **\--pcr**=_FILE_:

    Optional PCR input file to save the list of PCR values that were included
    in the quote.

  * **-l**, **\--pcr-list**=_PCR_:

    The list of PCR banks and selected PCRs' ids for each bank.

  * **-q**, **\--qualification**=_HEX\_STRING\_OR\_PATH_:

    Qualification data for the quote. Can either be a hex string or path.
    This is typically used to add a nonce against replay attacks.

  * **-F**, **\--format**=_FORMAT_:

    **DEPRECATED** and **IGNORED ** as it's superfluous.

## References

[algorithm specifiers](common/alg.md) details the options for specifying
cryptographic algorithms _ALGORITHM_.

[signature format specifiers](common/signature.md) option used to configure
signature _FORMAT_.

[common options](common/options.md) collection of common options that provide
information many users may expect.

[common tcti options](common/tcti.md) collection of options used to configure
the various known TCTI modules.

# EXAMPLES

## Generate a quote with a TPM, then verify it
```bash
tpm2_createek -c 0x81010001 -G rsa -u ekpub.pem -f pem

tpm2_createak -C 0x81010001 -c ak.ctx -G rsa -s rsassa -g sha256 \
-u akpub.pem -f pem -n ak.name

tpm2_quote -c ak.ctx -l sha256:15,16,22 -q abc123 -m quote.msg -s quote.sig \
  -o quote.pcrs -g sha256

tpm2_checkquote -u akpub.pem -m quote.msg -s quote.sig -f quote.pcrs -g sha256 \
  -q abc123
```

[returns](common/returns.md)

[footer](common/footer.md)
