/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

class Graph
extends JPanel {
    static final int BORDER_LEFT = 40;
    static final int BORDER_RIGHT = 0;
    static final int BORDER_TOP = 10;
    static final int BORDER_BOTTOM = 10;
    static final int TICK_SPACING = 40;
    static final int MAX_TICKS = 16;
    static final int TICK_WIDTH = 10;
    static final int MIN_WIDTH = 50;
    int gx0;
    int gx1;
    int gy0;
    int gy1;
    int scale = 2;
    Window parent;
    int height;
    int width;
    double xscale;
    double yscale;

    void updateConversion() {
        this.height = this.getHeight() - 10 - 10;
        this.width = this.getWidth() - 40 - 0;
        if (this.height < 1) {
            this.height = 1;
        }
        if (this.width < 1) {
            this.width = 1;
        }
        this.xscale = (double)this.width / (double)(this.gx1 - this.gx0 + 1);
        this.yscale = (double)this.height / (double)(this.gy1 - this.gy0 + 1);
    }

    Graphics makeClip(Graphics graphics) {
        return graphics.create(40, 10, this.width, this.height);
    }

    int screenX(int n) {
        return (int)(this.xscale * (double)(n - this.gx0) + 0.5);
    }

    int screenY(int n) {
        return (int)((double)this.height - this.yscale * (double)(n - this.gy0));
    }

    int graphX(int n) {
        return (int)((double)n / this.xscale + (double)this.gx0 + 0.5);
    }

    Graph(Window window) {
        this.parent = window;
        this.gy0 = 0;
        this.gy1 = 65535;
        this.gx0 = 0;
        this.gx1 = 50 << this.scale;
    }

    void rightDrawString(Graphics2D graphics2D, String string, int n, int n2) {
        TextLayout textLayout = new TextLayout(string, this.parent.smallFont, graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D = textLayout.getBounds();
        textLayout.draw(graphics2D, (float)n - (float)rectangle2D.getWidth(), (float)n2 + (float)rectangle2D.getHeight() / 2.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Oscilloscope oscilloscope = this.parent.parent;
        synchronized (oscilloscope) {
            this.updateConversion();
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawYAxis(graphics2D);
            Graphics graphics2 = this.makeClip(graphics2D);
            int n = this.parent.moteListModel.size();
            for (int i = 0; i < n; ++i) {
                graphics2.setColor(this.parent.moteListModel.getColor(i));
                this.drawGraph(graphics2, this.parent.moteListModel.get(i));
            }
        }
    }

    protected void drawYAxis(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4 = 39;
        int n5 = this.getHeight() - 10 - 10;
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(n4, 10, n4, 10 + n5 - 1);
        int n6 = n5 / 40;
        if (n6 > 16) {
            n6 = 16;
        }
        if ((n3 = (this.gy1 - this.gy0 + 1) / n6) == 0) {
            n3 = 1;
        }
        if ((n2 = (int)((double)n3 / Math.pow(10.0, n = (int)(Math.log(n3) / Math.log(10.0))) + 0.5)) > 2) {
            n2 = 5;
        } else if (n2 > 5) {
            n2 = 10;
        }
        n3 = n2 * (int)Math.pow(10.0, n);
        for (int i = (this.gy0 + n3 - 1) / n3 * n3; i <= this.gy1; i += n3) {
            int n7 = this.screenY(i) + 10;
            this.rightDrawString(graphics2D, "" + i, n4 - 5 - 2, n7);
            graphics2D.drawLine(n4 - 5, n7, n4 - 5 + 10, n7);
        }
    }

    protected void drawGraph(Graphics graphics, int n) {
        SingleGraph singleGraph = new SingleGraph(graphics, n);
        if (this.gx1 - this.gx0 >= this.width) {
            for (int i = 0; i < this.width; ++i) {
                singleGraph.nextPoint(graphics, this.graphX(i), i);
            }
        } else {
            for (int i = this.gx0; i <= this.gx1; ++i) {
                singleGraph.nextPoint(graphics, i, this.screenX(i));
            }
        }
    }

    void updateXLabel() {
        this.parent.xLabel.setText("X: " + this.gx0 + " - " + this.gx1);
    }

    private void recenter(int n) {
        int n2 = (this.gx1 - this.gx0 >> 2) + (n - this.gx1);
        this.gx0 += n2;
        this.gx1 += n2;
        if (this.gx0 < 0) {
            this.gx1 -= this.gx0;
            this.gx0 = 0;
        }
        this.updateXLabel();
    }

    void newData() {
        int n = this.parent.parent.data.maxX();
        if (n > this.gx1 || n < this.gx0) {
            this.recenter(n);
        }
        this.repaint();
    }

    void setScale(int n) {
        this.gx1 = this.gx0 + (50 << n);
        this.scale = n;
        this.recenter(this.parent.parent.data.maxX());
        this.repaint();
    }

    boolean setYAxis(int n, int n2) {
        if (n >= n2 || n < 0 || n > 65535 || n2 < 0 || n2 > 65535) {
            return false;
        }
        this.gy0 = n;
        this.gy1 = n2;
        this.repaint();
        return true;
    }

    private class SingleGraph {
        int lastsx;
        int lastsy;
        int nodeId;

        SingleGraph(Graphics graphics, int n) {
            this.nodeId = n;
            this.lastsx = -1;
            this.lastsy = -1;
        }

        void nextPoint(Graphics graphics, int n, int n2) {
            int n3 = Graph.this.parent.parent.data.getData(this.nodeId, n);
            int n4 = -1;
            if (n3 >= 0) {
                double d = (double)Graph.this.height - Graph.this.yscale * (double)(n3 - Graph.this.gy0);
                if (d >= -1000000.0 && d <= 1000000.0) {
                    n4 = (int)(d + 0.5);
                }
                if (this.lastsy >= 0 && n4 >= 0) {
                    graphics.drawLine(this.lastsx, this.lastsy, n2, n4);
                }
            }
            this.lastsx = n2;
            this.lastsy = n4;
        }
    }
}

