/*
 * OffsetDialog.java
 *
 * Created on 03 February 2008, 12:54
 */
package uk.co.mccombe.terrain;

import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

/**
 *
 * @author  Mike
 */
public class OffsetDialog extends javax.swing.JDialog {

    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    /** Creates new form OffsetDialog
     * @param parent the parent frame for the Dialog
     * @param modal true if the Dialog is to be modal
     * @param east - initialiser for the East offset field
     * @param north - initialiser for the North offset field
     * @param ht - initialiser for the height offset field
     */
    public OffsetDialog(java.awt.Frame parent, boolean modal, double east, double north, double ht) {
        super(parent, modal);
        initComponents();
        eastText.setInputVerifier(numbercheck);
        northText.setInputVerifier(numbercheck);
        heightText.setInputVerifier(numbercheck);
        eastText.setText(String.format(formatString, east));
        northText.setText(String.format(formatString, north));
        heightText.setText(String.format(formatString, ht));
    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        eastText = new javax.swing.JTextField();
        northText = new javax.swing.JTextField();
        heightText = new javax.swing.JTextField();

        setTitle("Set offset values");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("The following offsets will be added to data when it is saved");

        jLabel2.setText("Easting");

        jLabel3.setText("Northing");

        jLabel4.setText("Height");

        eastText.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        eastText.setText("0.0");

        northText.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        northText.setText("0.0");

        heightText.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
        heightText.setText("0.0");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(250, Short.MAX_VALUE)
                .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cancelButton)
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 325, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(65, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(heightText)
                    .addComponent(northText)
                    .addComponent(eastText, javax.swing.GroupLayout.DEFAULT_SIZE, 99, Short.MAX_VALUE))
                .addContainerGap(201, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {cancelButton, okButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(eastText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(northText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(heightText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        eastOffset = parseDouble(eastText.getText());
        northOffset = parseDouble(northText.getText());
        heightOffset = parseDouble(heightText.getText());
        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed
    private double parseDouble(String s){
            String val = s.trim();
            if (val.startsWith("+")) {
                val = val.substring(1);
            }
            java.text.NumberFormat nf = java.text.NumberFormat.getInstance();
            java.text.ParsePosition pos = new java.text.ParsePosition(0);
            return nf.parse(val, pos).doubleValue();
    }
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose(RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                OffsetDialog dialog = new OffsetDialog(new javax.swing.JFrame(), true, 0.0, 0.0, 0.0);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public double getEastOffset() {
        return eastOffset;
    }

    public double getNorthOffset() {
        return northOffset;
    }

    public double getHeightOffset() {
        return heightOffset;
    }

    private class NumericVerifier extends InputVerifier {

        @Override
        public boolean verify(JComponent input) {
            JTextField field = (JTextField) input;
            String val = field.getText().trim();
            if (val.startsWith("+")) {
                val = val.substring(1);
            }
            java.text.NumberFormat nf = java.text.NumberFormat.getInstance();
            java.text.ParsePosition pos = new java.text.ParsePosition(0);
            int n = val.length();
            double x = nf.parse(val, pos).doubleValue();
            if (pos.getIndex() != n) {
                return false;
            }
            field.setText(String.format(formatString, x));
            return true;
        /*
        boolean res = val.trim().matches("[+-]?\\d+\\[,.]?\\d*$");
        if (res) {
        double x = Double.parseDouble(val.trim());
        field.setText(String.format(formatString, x));
        }
        return res;
         */
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextField eastText;
    private javax.swing.JTextField heightText;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField northText;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables
    private int returnStatus = RET_CANCEL;
    private static final String formatString = "%12.1f";
    private double eastOffset = 0.0;
    private double northOffset = 0.0;
    private double heightOffset = 0.0;
    private NumericVerifier numbercheck = new NumericVerifier();
}
