'\"
'\" Generated from file 'ripemd160\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004, Pat Thoyts <patthoyts@users\&.sourceforge\&.net>
'\"
.TH "ripemd160" n 1\&.0\&.5 tcllib "RIPEMD Message-Digest Algorithm"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
ripemd160 \- RIPEMD-160 Message-Digest Algorithm
.SH SYNOPSIS
package require \fBTcl  8\&.2\fR
.sp
package require \fBripemd160  ?1\&.0\&.5?\fR
.sp
\fB::ripemd::ripemd160\fR ?\fI-hex\fR? [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
.sp
\fB::ripemd::hmac160\fR ?\fI-hex\fR? \fI-key key\fR [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
.sp
\fB::ripemd::RIPEMD160Init\fR
.sp
\fB::ripemd::RIPEMD160Update\fR \fItoken\fR \fIdata\fR
.sp
\fB::ripemd::RIPEMD160Final\fR \fItoken\fR
.sp
\fB::ripemd::RIPEHMAC160Init\fR \fIkey\fR
.sp
\fB::ripemd::RIPEHMAC160Update\fR \fItoken\fR \fIdata\fR
.sp
\fB::ripemd::RIPEHMAC160Final\fR \fItoken\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package is an implementation in Tcl of the RIPEMD-160 message-digest
algorithm (1)\&. This algorithm takes an arbitrary quantity of data and
generates a 160-bit message digest from the input\&. The RIPEMD-160
algorithm is based upon the MD4 algorithm (2, 4) but has been
cryptographically strengthened against weaknesses that have been found
in MD4 (4)\&.
.PP
This package will use \fBcryptkit\fR or \fBTrf\fR to
accelerate the digest computation if either package is available\&. In
the absence of an accelerator package the pure-Tcl implementation will
be used\&.
.SH COMMANDS
.TP
\fB::ripemd::ripemd160\fR ?\fI-hex\fR? [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
Calculate the RIPEMD-160 digest of the data given in string\&. This is
returned as a binary string by default\&. Giving the \fI-hex\fR option
will return a hexadecimal encoded version of the digest\&.
.sp
The data to be hashed can be specified either as a string argument to
the ripemd160 command, or as a filename or a pre-opened channel\&. If the
\fI-filename\fR argument is given then the file is opened, the data read
and hashed and the file is closed\&. If the \fI-channel\fR argument is
given then data is read from the channel until the end of file\&. The
channel is not closed\&.
.sp
Only one of \fI-file\fR, \fI-channel\fR or \fIstring\fR should be given\&.
.TP
\fB::ripemd::hmac160\fR ?\fI-hex\fR? \fI-key key\fR [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
Calculate an Hashed Message Authentication digest (HMAC) using the
RIPEMD-160 digest algorithm\&. HMACs are described in RFC 2104 (5) and
provide a RIPEMD-160 digest that includes a key\&. All options other
than \fI-key\fR are as for the \fB::ripemd::ripemd160\fR command\&.
.PP
.SH "PROGRAMMING INTERFACE"
For the programmer, hash functions can be viewed as a bucket into which
one pours data\&. When you have finished, you extract a value that is
uniquely derived from the data that was poured into the bucket\&. The
programming interface to the hash operates on a token (equivalent to the
bucket)\&. You call \fBRIPEMD160Init\fR to obtain a token and then call
\fBRIPEMD160Update\fR as many times as required to add data to the hash\&. To
release any resources and obtain the hash value, you then call
\fBRIPEMD160Final\fR\&. An equivalent set of functions gives you a keyed
digest (HMAC)\&.
.TP
\fB::ripemd::RIPEMD160Init\fR
Begins a new RIPEMD-160 hash\&. Returns a token ID that must be used for the
remaining functions\&.
.TP
\fB::ripemd::RIPEMD160Update\fR \fItoken\fR \fIdata\fR
Add data to the hash identified by token\&. Calling
\fIRIPEMD160Update $token "abcd"\fR is equivalent to calling
\fIRIPEMD160Update $token "ab"\fR followed by
\fIRIPEMD160Update $token "cb"\fR\&. See \fBEXAMPLES\fR\&.
.TP
\fB::ripemd::RIPEMD160Final\fR \fItoken\fR
Returns the hash value and releases any resources held by this
token\&. Once this command completes the token will be invalid\&. The
result is a binary string of 16 bytes representing the 160 bit
RIPEMD-160 digest value\&.
.TP
\fB::ripemd::RIPEHMAC160Init\fR \fIkey\fR
This is equivalent to the \fB::ripemd::RIPEMD160Init\fR command
except that it requires the key that will be included in the HMAC\&.
.TP
\fB::ripemd::RIPEHMAC160Update\fR \fItoken\fR \fIdata\fR
.TP
\fB::ripemd::RIPEHMAC160Final\fR \fItoken\fR
These commands are identical to the RIPEMD160 equivalent commands\&.
.PP
.SH EXAMPLES
.CS


% ripemd::ripemd160 -hex "Tcl does RIPEMD-160"
0829dea75a1a7074c702896723fe37763481a0a7

.CE
.CS


% ripemd::hmac160 -hex -key Sekret "Tcl does RIPEMD-160"
bf0c927231733686731dddb470b64a9c23f7f53b

.CE
.CS


% set tok [ripemd::RIPEMD160Init]
::ripemd::1
% ripemd::RIPEMD160Update $tok "Tcl "
% ripemd::RIPEMD160Update $tok "does "
% ripemd::RIPEMD160Update $tok "RIPEMD-160"
% ripemd::Hex [ripemd::RIPEMD160Final $tok]
0829dea75a1a7074c702896723fe37763481a0a7

.CE
.SH REFERENCES
.IP [1]
H\&. Dobbertin, A\&. Bosselaers, B\&. Preneel,
"RIPEMD-160, a strengthened version of RIPEMD"
\fIhttp://www\&.esat\&.kuleuven\&.ac\&.be/~cosicart/pdf/AB-9601/AB-9601\&.pdf\fR
.IP [2]
Rivest, R\&., "The MD4 Message Digest Algorithm", RFC 1320, MIT,
April 1992\&. (\fIhttp://www\&.rfc-editor\&.org/rfc/rfc1320\&.txt\fR)
.IP [3]
Rivest, R\&., "The MD4 message digest algorithm", in A\&.J\&.  Menezes
and S\&.A\&. Vanstone, editors, Advances in Cryptology - CRYPTO '90
Proceedings, pages 303-311, Springer-Verlag, 1991\&.
.IP [4]
Dobbertin, H\&., "Cryptanalysis of MD4", Journal of Cryptology
vol 11 (4), pp\&. 253-271 (1998)
.IP [5]
Krawczyk, H\&., Bellare, M\&. and Canetti, R\&. "HMAC: Keyed-Hashing for
Message Authentication", RFC 2104, February 1997\&.
(\fIhttp://www\&.rfc-editor\&.org/rfc/rfc2104\&.txt\fR)
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIripemd\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
md4, md5, ripemd128, sha1
.SH KEYWORDS
RIPEMD, hashing, md4, message-digest, rfc 1320, rfc 1321, rfc 2104, security
.SH CATEGORY
Hashes, checksums, and encryption
.SH COPYRIGHT
.nf
Copyright (c) 2004, Pat Thoyts <patthoyts@users\&.sourceforge\&.net>

.fi