from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       






class QAbstractExtensionFactory(_Mock):
  pass


class QAbstractExtensionManager(_Mock):
  pass


class QAbstractFormBuilder(_Mock):
  pass


class QDesignerActionEditorInterface(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QDesignerContainerExtension(_Mock):
  pass


class QDesignerCustomWidgetCollectionInterface(_Mock):
  pass


class QDesignerCustomWidgetInterface(_Mock):
  pass


class QDesignerFormEditorInterface(_Mock):
  pass


class QDesignerFormWindowCursorInterface(_Mock):
  pass
  Down = 8
  End = 2
  KeepAnchor = 1
  Left = 5
  MoveAnchor = 0
  Next = 3
  NoMove = 0
  Prev = 4
  Right = 6
  Start = 1
  Up = 7

class QDesignerFormWindowInterface(_Mock):
  pass
  DefaultFeature = 3
  DrawChildren = 2
  DrawWindowBackground = 1
  EditFeature = 1
  GridFeature = 2
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  TabOrderFeature = 4

class QDesignerFormWindowManagerInterface(_Mock):
  pass


class QDesignerMemberSheetExtension(_Mock):
  pass


class QDesignerObjectInspectorInterface(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QDesignerPropertyEditorInterface(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QDesignerPropertySheetExtension(_Mock):
  pass


class QDesignerTaskMenuExtension(_Mock):
  pass


class QDesignerWidgetBoxInterface(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QExtensionFactory(_Mock):
  pass


class QExtensionManager(_Mock):
  pass


class QFormBuilder(_Mock):
  pass


class QPyDesignerContainerExtension(_Mock):
  pass


class QPyDesignerCustomWidgetCollectionPlugin(_Mock):
  pass


class QPyDesignerCustomWidgetPlugin(_Mock):
  pass


class QPyDesignerMemberSheetExtension(_Mock):
  pass


class QPyDesignerPropertySheetExtension(_Mock):
  pass


class QPyDesignerTaskMenuExtension(_Mock):
  pass


