from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


Plot = _Mock()

_COLORMAP_CURSOR_COLORS = _Mock()

_cursorColorForColormap = _Mock()

np = _Mock()

qt = _Mock()



class ImageView(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  HISTOGRAMS_COLOR = 'blue'
  HISTOGRAMS_HEIGHT = 200
  IMAGE_MIN_SIZE = 200
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class ImageViewMainWindow(_Mock):
  pass
  AllowNestedDocks = 2
  AllowTabbedDocks = 4
  AnimatedDocks = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ForceTabbedDocks = 8
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  VerticalTabs = 16

class LimitsToolBar(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class PlotWindow(_Mock):
  pass
  AllowNestedDocks = 2
  AllowTabbedDocks = 4
  AnimatedDocks = 1
  DEFAULT_COLORMAP_INDEX = 2
  DEFAULT_COLORMAP_LOG_FLAG = False
  DrawChildren = 2
  DrawWindowBackground = 1
  ForceTabbedDocks = 8
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  VerticalTabs = 16
  defaultBackend = 'matplotlib'

class ProfileToolBar(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  _POLYGON_LEGEND = '__ProfileToolBar_ROI_Polygon'

class RadarView(_Mock):
  pass
  AnchorUnderMouse = 2
  AnchorViewCenter = 1
  BoundingRectViewportUpdate = 4
  Box = 1
  CacheBackground = 1
  CacheNone = 0
  DontAdjustForAntialiasing = 4
  DontClipPainter = 1
  DontSavePainterState = 2
  DrawChildren = 2
  DrawWindowBackground = 1
  FullViewportUpdate = 0
  HLine = 4
  IgnoreMask = 4
  MinimalViewportUpdate = 1
  NoAnchor = 0
  NoDrag = 0
  NoFrame = 0
  NoViewportUpdate = 3
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  RubberBandDrag = 2
  ScrollHandDrag = 1
  Shadow_Mask = 240
  Shape_Mask = 15
  SmartViewportUpdate = 2
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3
  _PIXMAP_SIZE = 256
  _TOOLTIP = 'Radar View:\nVisible area (in red)\nof the image (in gray).'

