from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


DataObject = _Mock()

DataSource = _Mock()

numpy = _Mock()

os = _Mock()

source_types = _Mock()

specfile = _Mock()

sys = _Mock()

types = _Mock()

DEBUG = 0

SF_EMPTY = 0

SF_MCA = 4

SF_MESH = 2

SF_NMCA = 8

SF_SCAN = 1

SF_UMCA = 16

SOURCE_TYPE = 'SpecFile'

class SpecFileDataSource(_Mock):
  pass
  Error = 'SpecFileDataError'

