from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


auto = _Mock()

basic = _Mock()

code = _Mock()

config = _Mock()

deprecated = _Mock()

display = _Mock()

execution = _Mock()

extension = _Mock()

history = _Mock()

logging = _Mock()

magics_class = _Mock()

namespace = _Mock()

osm = _Mock()

pylab = _Mock()

script = _Mock()



class AutoMagics(_Mock):
  pass
  registered = True

class BasicMagics(_Mock):
  pass
  registered = True

class CodeMagics(_Mock):
  pass
  registered = True

class ConfigMagics(_Mock):
  pass
  registered = True

class DeprecatedMagics(_Mock):
  pass
  registered = True

class DisplayMagics(_Mock):
  pass
  registered = True

class ExecutionMagics(_Mock):
  pass
  registered = True

class ExtensionMagics(_Mock):
  pass
  registered = True

class HistoryMagics(_Mock):
  pass
  registered = True

class LoggingMagics(_Mock):
  pass
  registered = True

class MacroToEdit(_Mock):
  pass


class Magics(_Mock):
  pass
  registered = False

class NamespaceMagics(_Mock):
  pass
  registered = True

class OSMagics(_Mock):
  pass
  registered = True

class PylabMagics(_Mock):
  pass
  registered = True

class ScriptMagics(_Mock):
  pass
  registered = True

class UserMagics(_Mock):
  pass
  registered = True

