
from dolfin import *
parameters["form_compiler"]["name"] = "sfc"

class Source(Expression): 
    def value_shape(self):
        return (2,2)
    def eval(self, values, x): 
        values[0] = x[0]
        values[1] = x[1]
        values[2] = 2
        values[3] = 100 

mesh = UnitSquare(12,12)

V0 = FunctionSpace(mesh, "DG", 0)
V1 = FunctionSpace(mesh, "CG", 1)
T1 = TensorFunctionSpace(mesh, "CG", 1)
T2 = TensorFunctionSpace(mesh, "CG", 2)

u = TrialFunction(T1)
v = TestFunction(T1)

U = Function(T1)

c = Function(V0)
c.vector()[:] = 1

f = Source()

a = c*inner(u,v)*dx
L = inner(f,v)*dx


solve(a==L, U)

# Store tensor valued function to file
file = File('u.pvd')
file << U

# Plot components of tensor
plot(project(U[0,0], V1))
plot(project(U[0,1], V1))
plot(project(U[1,0], V1))
plot(project(U[1,1], V1))
interactive()
