/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFF_H
#define _SC_DIFF_H

// sc
#include "util/FileData.h"
#include "util/String.h"
class DiffInfoModel;
namespace sc {
  class Error;
}


class Diff
{
public:
  Diff( const FileDataPtr original, const FileDataPtr modified );
  ~Diff();

  const sc::Error* diff( bool ignoreWhitespace = false );

  DiffInfoModel* getDiffInfo() const
  {
    return _diffInfo;
  }

private:
  // in
  FileDataPtr _original;
  FileDataPtr _modified;

  // out
  DiffInfoModel* _diffInfo;
};

#endif // _SC_DIFF_H
