/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COLORSETTINGS_H
#define _SC_COLORSETTINGS_H

// sc
#include "util/String.h"

// qt
#include <QtGui/QColor>

// sys
#include <vector>


class Color
{
public:
  Color( long id, const QString& name, const QColor& color, const QString& desc )
    : _id(id), _name(name), _color(color), _desc(desc)
  {
  }

  long    _id;

  QString _name;
  QColor  _color;

  QString _desc;
};

typedef std::vector<Color> Colors;


class ColorSettings
{
public:
  virtual ~ColorSettings(){}

  virtual void getColors( Colors& ) = 0;
  virtual void setColors( const Colors& ) = 0;
};

#endif // _SC_COLORSETTINGS_H
