/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RESOLVEDPARAM_H
#define _SC_RESOLVEDPARAM_H

// sc
#include "ScParam.h"
#include "svn/ClientTypes.h"
#include "util/String.h"


/**
 * Parameter class for ResolvedCmd.
 */
class ResolvedParam : public ScParam
{
public:
  ResolvedParam( const sc::String& path, bool recurse )
    : _path(path), _recurse(recurse)
  {
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  ScParamAccept(ResolvedParam);

private:
  // in
  sc::String _path;
  bool       _recurse;
};

#endif // _SC_RESOLVEDPARAM_H
