/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPLISTPARAM_H
#define _SC_PROPLISTPARAM_H

// sc
#include "ScParam.h"
#include "ScParamVisitor.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/PropListItemTypes.h"


/**
 * Parameter class for PropListCmd.
 */
class PropListParam : public ScParam
{
public:
  PropListParam( const sc::String& pathOrUrl, const svn::Revision* rev, bool recurse )
    : _pathOrUrl(pathOrUrl), _rev(rev), _recurse(recurse)
  {
  }

  ~PropListParam()
  {
    delete _rev;
  }

  const sc::String& getPathOrUrl() const
  {
    return _pathOrUrl;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::PropListItems& getItems()
  {
    return _items;
  }

  ScParamAccept(PropListParam);

private:
  // in
  sc::String           _pathOrUrl;
  const svn::Revision* _rev;
  bool                 _recurse;
  
  // out
  svn::PropListItems   _items;
};

#endif // _SC_PROPLISTPARAM_H
