/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_TREEVIEW_H
#define _SC_TREEVIEW_H

// qt
#include <QtGui/QTreeView>
#include <QtCore/QTime>

/**
 * Extends QTreeView with Subcommander specific scrolling and drag and drop
 * support.
 */
class TreeView : public QTreeView
{
  typedef QTreeView super;
  Q_OBJECT

public:
  TreeView( QWidget* parent );

  void mousePressEvent( QMouseEvent* e );
  void mouseMoveEvent( QMouseEvent* e );
  void dragEnterEvent( QDragEnterEvent* e );
  void dragMoveEvent( QDragMoveEvent* e );
  void dragLeaveEvent( QDragLeaveEvent* e );
  void dropEvent( QDropEvent* e );
  void timerEvent( QTimerEvent* e );

protected:
  /** check if the drag start condition is met. */
  bool dragStartable() const;

  /** get the maximum scrollable height. */
  int maximumHeight();
  /** get the visible scrollable height. */
  int visibleHeight();

  /** calc scroll delta based on current mouse @a pos, @a maximumHeight and @a
   * visibleHeight. */
  int calcScrollDelta( const QPoint& pos, int maximumHeight, int visibleHeight );

  /** handle auto expand. */
  void autoExpand( QTimerEvent* e );

private:
  QPoint _lastMousePos;           ///< last mouse position.
  QTime  _lastMouseTime;          ///< time of last mouse position.
  QPoint _lastMousePosLeftPress;  ///< last mouse position with left button press.

  /** active auto scroll & expand drag/drop timer, 0 if no timer is running. */
  int    _dragTimerId;
};

#endif // _SC_TREEVIEW_H
