/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_NOTIFY_H
#define _SC_NOTIFY_H

// sc
#include "util/String.h"
#include "svn/Notify.h"
class LogData;

// qt
class QObject;


/** Deliver subversion progress information. */
class Notify : public svn::NotifyBaton
{
public:
  Notify( unsigned long lid );
  Notify( unsigned long lid, QObject* target );

  void notify( svn::WcNotifyPtr );

private:
  unsigned long getType( svn::WcNotifyPtr );
  sc::String getAction( svn::WcNotifyPtr );
  sc::String getStatus( svn::WcNotifyPtr );
  sc::String getMessage( svn::WcNotifyPtr );

  void post( const LogData* data );

  unsigned long _lid;
  QObject*      _target;
};


#endif // _SC_NOTIFY_H
