/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CREATEREPOSITORYDIALOG_H
#define _SC_CREATEREPOSITORYDIALOG_H

// sc
class ExternProvider;
class ExternButton;

// qt
#include <QtGui/QDialog>
class QLineEdit;
class QPushButton;
class QCheckBox;
class QComboBox;


class CreateRepositoryDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  CreateRepositoryDialog( ExternProvider* p, QWidget* parent = 0 );
  virtual ~CreateRepositoryDialog();

  QString getName();
  QString getPath();

public slots:
  void checkOk( const QString& text );

private slots:
  void selectExtern();

private:
  QPixmap getPixmap();
  QString getType();

private:
  QLineEdit*      _name;
  QComboBox*      _path;
  QComboBox*      _type;
  ExternButton*   _ex;

  QPushButton*    _ok;
  QPushButton*    _ca;

  ExternProvider* _p;
};

#endif // _SC_CREATEREPOSITORYDIALOG_H
