SQL Library
===========

The package [stormname:sql] contains a SQL library. The library consists of two main parts:

- A set of interfaces to communicate with different databases.

- A language extension to Basic Storm that allows mixing SQL with Basic Storm in a type-safe way.
  The extension optionally provides type-safety through the database layer.

As such, documentation of the SQL library is divided into two sections. The first describes the
generic database interface, and the second describes the language extension.


The library currently supports SQLite, MariaDB, MySQL, and PostgreSQL.

On Linux, only SQLite is supported out of the box. Connecting to MariaDB and MySQL requires
installing `libmariadb3` (for `libmariadb.so`), and connecting to PostgreSQL requires installing
`libpq5` (for `libpq.so`). The exact version of these libraries is typically not important.

On Windows, the SQLite and MariaDB/MySQL driver is included in the distribution. Connecting to
PostgreSQL does, however, require downloading the PostgreSQL library separately. Download the zip
archive with binaries from
[https://www.postgresql.org/download/windows](https://www.postgresql.org/download/windows). Extract
the following files from the `bin` directory of the zip and put them either next to `Storm.exe` or
in the `root/sql/` directory:

- `libpq.dll`
- `libcrypto-*.dll`
- `libiconv-*.dll`
- `libintl-*.dll`
- `libssl-*.dll`

Note that precompiled binaries are only available for 64-bit Windows from version 11 and onwards. As
such, you need to run the 64-bit version of Storm to use PostgreSQL. The Storm implementation of
PostgreSQL does, however, support version 10 of the driver, which is available as 32-bit. However,
this version of the driver is unsupported by PostgreSQL, so while this might be a way out of a
pinch, it is not recommended.


The SQL library was originally developed by: David Ångström, Markus Larsson, Mohammed Hamade, Oscar
Falk, Robin Gustavsson, Saima Akhter. The support for MariaDB and MySQL was later added by [Hanna
Häger and Simon Westerberg Jernström](https://urn.kb.se/resolve?urn=urn:nbn:se:liu:diva-197986), and
the initial version for PostgreSQL support was implemented by
[Erik Eklöf](https://urn.kb.se/resolve?urn=urn:nbn:se:liu:diva-213093).

The ideas for supporting `RETURNING` in databases that do not support them natively was contributed
by [David Lundberg Sixtensson and Filip Wojtulewicz](https://urn.kb.se/resolve?urn=urn:nbn:se:liu:diva-215556).