use ui;
use layout;
use core:geometry;
use progvis:net;

dialog StatusDlg {
	layout Grid {
		wrapCols: 3;
		expandCol: 1;
		Label("Nickname:", VAlign:center) {}
		Label username("", VAlign:center) {}
		Button changeName("Change") {}
		nextLine;
		Label("Leaderboard:") { colspan: 3; }
		nextLine;
		Grid scoreGrid { colspan: 3; expandCol: 1; wrapCols: 3; }
	}

	private Client client;

	init(Client client) {
		init("Status", Size(200, 50)) {
			client = client;
		}

		username.text = client.username;
		changeName.onClick = &this.onChangeUsername();

		Score[] scores;
		try {
			if (ans = client.query(LeaderboardRequest()) as LeaderboardResponse) {
				scores = ans.scores;
			}

			for (score in scores) {
				Label place(score.place.toS + ":", HAlign:right);
				Label name(score.name);
				Label score(score.points.toS + " p", HAlign:right);
				add(place);
				add(name);
				add(score);
				scoreGrid.add(component(place));
				scoreGrid.add(component(name));
				scoreGrid.add(component(score));
				scoreGrid.nextLine;
			}
		} catch (Exception e) {
			Label error("Failed to fetch the leaderboard");
			add(error);
			scoreGrid.add(component(error));
		}
	}

	private void onChangeUsername() {
		UsernameDlg dlg;
		dlg.show(this);
		Str newName = dlg.name;
		if (newName.empty)
			return;

		try {
			client.query(ChangeNicknameRequest(newName));
			username.text = newName;
		} catch (Exception e) {
			showMessage(this, "Error", e.message);
		}
	}
}

dialog UsernameDlg {
	layout Grid {
		expandCol: 1;
		Label("New nickname:", VAlign:center) { row: 0; col: 0; }
		Edit username("Nickname") { row: 0; col: 1; colspan: 2; }
		Button ok("OK") { row: 1; col: 2; }
	}

	Str name;

	init() {
		init("Change username", Size(200, 10)) {}

		username.focus();
		defaultChoice(ok);
		ok.onClick = &this.done();
	}

	void done() {
		name = username.text;
		close(1);
	}

}
