use util:serialize;

/**
 * Misc. data types.
 */


/**
 * Representation of a single problem (no source code, intended for lists of problems).
 */
class Problem : serializable {
	Int id;

	Str title;
	Str author;

	// Number of solutions.
	Nat solutions;

	init(Int id, Str title, Str author, Nat solutions) {
		init {
			id = id;
			title = title;
			author = author;
			solutions = solutions;
		}
	}

	// For sorting.
	Bool <(Problem o) {
		id < o.id;
	}
}

/**
 * Representation of a single solution to a problem.
 *
 * Note: This *may* link to another problem, but may also simply say: this looks good to me.
 */
class Solution : serializable {
	// ID of this row in the DB.
	Int id;

	// ID if the problem we're a solution to.
	Int to;

	// Author of the solution.
	Str author;

	// Type of solution (a tag that can be used to describe if it was an exception, a race condition, etc.)
	Str type;

	// Solution, in string representation (if any).
	Str? solution;

	// Improved version, if any.
	Int? improved;

	init(Int id, Int to, Str author, Str type) {
		init {
			id = id;
			to = to;
			author = author;
			type = type;
		}
	}

	init(Int id, Int to, Str author, Str type, Str? solution, Int? improved) {
		init {
			id = id;
			to = to;
			author = author;
			type = type;
			solution = solution;
			improved = improved;
		}
	}

	// For sorting.
	Bool <(Solution o) {
		id < o.id;
	}
}


/**
 * A single high-score entry.
 */
class Score : serializable {
	Str name;
	Int points;
	Int place;

	init(Str name, Int points, Int place) {
		init {
			name = name;
			points = points;
			place = place;
		}
	}
}
