-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (ErrorHandler)
procedure AppendSym (Error : in out Error_Types.StringError;
                     Sym   : in     SP_Symbols.SP_Symbol) is
   --# hide AppendSym;

   procedure Append_Reserved_Word (S : String)
   --# global in out Error;
   --# derives Error from *,
   --#                    S;
   is
   begin
      Append_String (E_Str => Error,
                     Str   => S (S'First + 2 .. S'Last));
   end Append_Reserved_Word;

   ------------------------------------------

begin --AppendSym
   case Sym is
      when SP_Symbols.RWabort .. SP_Symbols.RWxor =>
         Append_String (E_Str => Error,
                        Str   => "reserved word """);
         Append_Reserved_Word (S => SP_Symbols.SP_Symbol'Image (Sym));
         Append_String (E_Str => Error,
                        Str   => """");
      when SP_Symbols.ampersand =>
         Append_String (E_Str => Error,
                        Str   => """&""");
      when SP_Symbols.apostrophe =>
         Append_String (E_Str => Error,
                        Str   => """'""");
      when SP_Symbols.left_paren =>
         Append_String (E_Str => Error,
                        Str   => """(""");
      when SP_Symbols.right_paren =>
         Append_String (E_Str => Error,
                        Str   => """)""");
      when SP_Symbols.multiply =>
         Append_String (E_Str => Error,
                        Str   => """*""");
      when SP_Symbols.plus =>
         Append_String (E_Str => Error,
                        Str   => """+""");
      when SP_Symbols.comma =>
         Append_String (E_Str => Error,
                        Str   => """,""");
      when SP_Symbols.minus =>
         Append_String (E_Str => Error,
                        Str   => """-""");
      when SP_Symbols.point =>
         Append_String (E_Str => Error,
                        Str   => """.""");
      when SP_Symbols.divide =>
         Append_String (E_Str => Error,
                        Str   => """/""");
      when SP_Symbols.colon =>
         Append_String (E_Str => Error,
                        Str   => """:""");
      when SP_Symbols.semicolon =>
         Append_String (E_Str => Error,
                        Str   => """;""");
      when SP_Symbols.less_than =>
         Append_String (E_Str => Error,
                        Str   => """<""");
      when SP_Symbols.equals =>
         Append_String (E_Str => Error,
                        Str   => """=""");
      when SP_Symbols.greater_than =>
         Append_String (E_Str => Error,
                        Str   => """>""");
      when SP_Symbols.vertical_bar =>
         Append_String (E_Str => Error,
                        Str   => """|""");
      when SP_Symbols.tilde =>
         Append_String (E_Str => Error,
                        Str   => """~""");
      when SP_Symbols.arrow =>
         Append_String (E_Str => Error,
                        Str   => """=>""");
      when SP_Symbols.double_dot =>
         Append_String (E_Str => Error,
                        Str   => """..""");
      when SP_Symbols.double_star =>
         Append_String (E_Str => Error,
                        Str   => """**""");
      when SP_Symbols.becomes =>
         Append_String (E_Str => Error,
                        Str   => """:=""");
      when SP_Symbols.not_equal =>
         Append_String (E_Str => Error,
                        Str   => """/=""");
      when SP_Symbols.greater_or_equal =>
         Append_String (E_Str => Error,
                        Str   => """>=""");
      when SP_Symbols.less_or_equal =>
         Append_String (E_Str => Error,
                        Str   => """<=""");
      when SP_Symbols.box =>
         Append_String (E_Str => Error,
                        Str   => """<>""");
      when SP_Symbols.implies =>
         Append_String (E_Str => Error,
                        Str   => """->""");
      when SP_Symbols.is_equivalent_to =>
         Append_String (E_Str => Error,
                        Str   => """<->""");
      when SP_Symbols.square_open =>
         Append_String (E_Str => Error,
                        Str   => """[""");
      when SP_Symbols.square_close =>
         Append_String (E_Str => Error,
                        Str   => """]""");
      when others =>
         Append_String (E_Str => Error,
                        Str   => SP_Symbols.SP_Symbol'Image (Sym));
   end case;
end AppendSym;
