9.2 Bucles en Vivo

# Bucles en Vivo 

Bien, ésta sección del tutorial es la joya de la corona. Si leyeses
sólo una sección, debería ser ésta. Si leíste la sección previa sobre
los Fundamentos de Live Coding, `live_loop` es una manera simple de
hacer exactamente eso, pero sin tener que escribir tanto.

Si no leíste la sección anterior, `live_loop` es como mejor se puede
tocar con Sonic Pi.

Toquemos algo. Escribe el siguiente código en un buffer nuevo:

```
live_loop :foo do
  play 60
  sleep 1
end
```

Presiona el botón de Run. Escucharás un beep básico en cada pulso. Nada
muy divertido en ello. Sin embargo, todavía no presiones Stop. Cambia
el `60` a `65` y presiona otra vez Run.

¡Woah Se cambió automáticamente sin perder un tan sólo pulso!¡Esto es Live
Coding!

Hagámoslo más a bajo, sólo cambiemos el código un poco:
```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8
  sleep 8
end
```

Ahora aprieta Run 

Movamos el punto de corte:

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Presiona Run otra vez.

Añadamos baterías:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```
Cambiemos la nota de `e1` a `c1`:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Ahora deja de leerme y cambia lo que quieras por tu cuenta.
¡Diviértete!
