/* Public domain. */

#include "bytestr.h"
#include "envalloc.h"

int envalloc_merge (envalloc *v, char const *const *envp, unsigned int envlen, char const *modifs, unsigned int modiflen)
{
  unsigned int vbase = v->len ;
  unsigned int j = 0 ;
  register unsigned int i = 0 ;
  if (!envalloc_readyplus(v, envlen + 1 + byte_count(modifs, modiflen, '\0')))
    return 0 ;
  envalloc_catb(v, envp, envlen) ;
  for (; i < modiflen ; i++)
  {
    if (!modifs[i])
    {
      register unsigned int t = vbase ;
      unsigned int split = str_chr(modifs + j, '=') ;
      for (; t < v->len ; t++)
      {
        if (!byte_diff(modifs + j, split, v->s[t])
         && (v->s[t][split] == '='))
        {
          v->s[t] = v->s[--v->len] ;
          break ;
        }
      }
      if (modifs[j + split]) v->s[v->len++] = modifs + j ;
      j = i + 1 ;
    }
  }
  return 1 ;
}
