/************************************************************************
 *
 * Copyright (C) 2009-2022 IRCAD France
 * Copyright (C) 2012-2020 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#pragma once

#include <cppunit/extensions/HelperMacros.h>

namespace sight::core::runtime::ut
{

/**
 * @brief   Test Runtime : read the modules in CommonLib
 */
class RuntimeTest : public CPPUNIT_NS::TestFixture
{
CPPUNIT_TEST_SUITE(RuntimeTest);
CPPUNIT_TEST(testLibrary);
CPPUNIT_TEST(testModule);
CPPUNIT_TEST(testOperations);
CPPUNIT_TEST(testPropertyTree);
CPPUNIT_TEST_SUITE_END();

public:

    RuntimeTest();

    // interface
    void setUp() override;
    void tearDown() override;

    static void testLibrary();
    static void testModule();
    static void testOperations();
    static void testPropertyTree();
};

} // namespace sight::core::runtime::ut
