#!/bin/sh
# ./debian/repack
# Repackage the source files as a DFSG tarball, with unnecessary
# files removed. 

TMPDIR=$(mktemp --directory)
trap "rm -fr ${TMPDIR} || exit 1" EXIT INT TERM

ver=$2
orig_tar=$3
tardir=$(dirname ${orig_tar})
debiandir=$(dirname $0)
pkgname=$(grep ^[^[:space:]] ${debiandir}/changelog | head -1|cut -d' ' -f1)

echo $pkgname $ver $orig_tar $tardir $wd

tar xf ${orig_tar} -C ${TMPDIR} 
srcdir=$(ls -d ${TMPDIR}/*)

if [ -f ${debiandir}/dfsg.move ] ; then
  ( while read source target ; do
      mkdir -p ${srcdir}/${target}
      mv ${srcdir}/${source} ${srcdir}/${target}
    done ) < ${debiandir}/dfsg.move
fi

for fname in $(cat ${debiandir}/dfsg.remove | sed s/\#.\*//); do
    rm -rf ${srcdir}/${fname}
done

dfsg_tar=${tardir}/${pkgname}_${ver}+dfsg.orig.tar.gz
tar czf ${dfsg_tar} -C ${TMPDIR} .

exec uupdate --no-symlink --upstream-version ${ver}+dfsg ${dfsg_tar}
