/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCMXX_OPT_H
#define SCMXX_OPT_H

#include "options.h"
#include "ttyaccess.h"

extern struct args_def_type args_type_list[];
extern struct args_def args_list[];

#define SCMXX_ACTION_REMOVE 0x1
#define SCMXX_ACTION_SEND   0x2
#define SCMXX_ACTION_GET    0x4

#define SCMXX_FTYPE_BINARY 0x1
#define SCMXX_FTYPE_PBOOK  0x2
#define SCMXX_FTYPE_SMS    0x4

#define SCMXX_SLOT_LAST       -7
#define SCMXX_SLOT_SMS_SENT   -6
#define SCMXX_SLOT_SMS_UNSENT -5
#define SCMXX_SLOT_SMS_READ   -4
#define SCMXX_SLOT_SMS_UNREAD -3
#define SCMXX_SLOT_ALL        -2
#define SCMXX_SLOT_UNDEFINED  -1

#define SCMXX_SLOT_BINARY_MIN 0
#define SCMXX_SLOT_PBOOK_MIN  1
#define SCMXX_SLOT_SMS_MIN    1

#define VCARD_PHONEBOOK_NAME "VCF"

/* various SMS options */
struct smsopts {
  //for sending
  unsigned int flash :1;
  unsigned int srr :1;
  unsigned int unicode :1;

  /* to be removed from here
   * should be in the application, only
   */
  unsigned int direct :1;
  char* sort_mode;
};

struct parameters {
  char* text;
  char* number;
  int slot;
  char* mem;
};

struct args_t {
  struct port_args_t port;

  struct parameters myparams;
  struct smsopts mysmsopts;

  char scmxx_action;
  char scmxx_ftype;

  char* myFILE;
  char* myPIPE;

  unsigned int info :1;
  unsigned int meminfo :1;
  unsigned int lockinfo :1;
  unsigned int time :1;
  char* lock;
  int state_change;
  unsigned int smsc :1;
  unsigned int dial :1;
  unsigned int hangup :1;
  unsigned int reset :1;
  unsigned int help :1;
  unsigned int version :1;

  int verbose;
  char* pin;
  char* system_charset;
};

/* a function to init the variables in the struct
 */
void args_init ();
void scmxx_use_envvars ();
int scmxx_conffile_parse (char* filename);
char** scmxx_args_parse (int argc, char** argv);
struct args_t* scmxx_get_args ();

#endif
