// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - SE - Sylvestre Ledru
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

A=[-0.7  0    0.3  0   -0.5 -0.1
   -0.6  0.2 -0.4 -0.3  0    0
   -0.5  0.7 -0.1  0    0   -0.8
   -0.7  0    0   -0.5 -1    0
    0    0.3  0.6 -0.9  0.1 -0.4
    0.5 -0.8  0    0    0.2 -0.9];
B=[-1 -2 -2  1  0
    1  0  1 -2  1
   -3 -4  0  2 -2
    1 -2  1  0 -1
    0  1 -2  0  3
    1  0  3 -1 -2];
C=[ 1 -1  2 -2  0 -3
   -3  0  1 -1  1  0
    0  2  0 -4  0 -2
    1 -3  0  0  3  1
    0  1 -2  1  0 -2];
D=[1 -1 -2  0  0
   0  1  0  1  0
   2 -1 -3  0  1
   0  1  0  1 -1
   0  0  1  2  1];

ncon=2
nmeas=2
gam=111.30;
[AK,BK,CK,DK] = dhinf(A,B,C,D,ncon,nmeas,gam);

DK_ref=[9.0643622,7.5621326;
-3.4130376,-2.8323139];

CK_ref=[-9.2274286,27.617295,13.786069,-0.3641854,-21.675515,9.6380172;
3.661606,-10.657654,-5.2960847,0.2432695,8.1401006,-3.6427294];

BK_ref=[17.040893,14.216801;
-18.990171,-15.73011;
25.296356,21.361546;
20.185869,16.893822;
1.4151937,1.2079724;
5.3371104,4.5307879];

AK_ref=[-18.066348,52.229142,26.177583,-0.4276594,-41.049028,18.153152;
18.890371,-57.836295,-29.19831,0.5876879,45.493269,-19.939051;
-26.692988,78.252232,39.17635,-1.4029006,-60.329721,26.790618;
-21.491455,62.399041,30.862738,-0.9208084,-48.796168,21.915137;
-0.8960266,4.2934499,2.3358869,-0.2424272,-3.0488883,1.2220794;
-5.347976,16.254159,8.5113556,-0.2490600,-12.279774,5.1796586];

assert_checkalmostequal(AK,AK_ref, 1.e-6 );
assert_checkalmostequal(BK,BK_ref, 1.e-6 );
assert_checkalmostequal(CK,CK_ref, 1.e-6 );
assert_checkalmostequal(DK,DK_ref, 1.e-6 );
