//! Tests auto-converted from "sass-spec/spec/core_functions/color/to_space/rec2020/xyz_d50.hrx"

#[allow(unused)]
fn runner() -> crate::TestRunner {
    super::runner().with_cwd("xyz_d50")
}

mod alpha {
    #[allow(unused)]
    use super::runner;

    #[test]
    #[ignore] // unexepected error
    fn partial() {
        assert_eq!(
        runner().ok(
            "@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0.1 0.2 0.3 / 0.4), xyz-d50)}\n"
        ),
        "a {\
         \n  b: color(xyz-d50 0.0375225748 0.0485727436 0.0855889676 / 0.4);\
         \n}\n"
    );
    }
    #[test]
    #[ignore] // unexepected error
    fn transparent() {
        assert_eq!(
        runner().ok(
            "@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0.1 0.2 0.3 / 0.0), xyz-d50)}\n"
        ),
        "a {\
         \n  b: color(xyz-d50 0.0375225748 0.0485727436 0.0855889676 / 0);\
         \n}\n"
    );
    }
}
#[test]
#[ignore] // unexepected error
fn black() {
    assert_eq!(
        runner().ok("@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0 0 0), xyz-d50)}\n"),
        "a {\
         \n  b: color(xyz-d50 0 0 0);\
         \n}\n"
    );
}
#[test]
#[ignore] // unexepected error
fn gray() {
    assert_eq!(
        runner().ok("@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0.5 0.5 0.5), xyz-d50)}\n"),
        "a {\
         \n  b: color(xyz-d50 0.2504463303 0.2597194371 0.2142957029);\
         \n}\n"
    );
}
#[test]
#[ignore] // unexepected error
fn middle() {
    assert_eq!(
        runner().ok("@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0.2 0.4 0.8), xyz-d50)}\n"),
        "a {\
         \n  b: color(xyz-d50 0.1461303676 0.1615955499 0.5152185696);\
         \n}\n"
    );
}
mod missing {
    #[allow(unused)]
    use super::runner;

    #[test]
    #[ignore] // unexepected error
    fn blue() {
        assert_eq!(
            runner().ok(
                "@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0.1 0.2 none), xyz-d50)}\n"
            ),
            "a {\
         \n  b: color(xyz-d50 0.0243454002 0.0437664763 none);\
         \n}\n"
        );
    }
    #[test]
    #[ignore] // unexepected error
    fn green() {
        assert_eq!(
            runner().ok(
                "@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 0.1 none 0.3), xyz-d50)}\n"
            ),
            "a {\
         \n  b: color(xyz-d50 0.0283237743 none 0.0839247274);\
         \n}\n"
        );
    }
    #[test]
    #[ignore] // unexepected error
    fn red() {
        assert_eq!(
            runner().ok(
                "@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 none 0.2 0.3), xyz-d50)}\n"
            ),
            "a {\
         \n  b: color(xyz-d50 none 0.0422970228 0.0856324257);\
         \n}\n"
        );
    }
}
mod out_of_range {
    #[allow(unused)]
    use super::runner;

    #[test]
    #[ignore] // unexepected error
    fn far() {
        assert_eq!(
        runner().ok(
            "@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 -999999 0 0), xyz-d50)}\n"
        ),
        "a {\
         \n  b: color(xyz-d50 -11757457714802.084 -4871490904380.732 33734088609.397465);\
         \n}\n"
    );
    }
    #[test]
    #[ignore] // unexepected error
    fn near() {
        assert_eq!(
            runner().ok("@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 -1 0.4 2), xyz-d50)}\n"),
            "a {\
         \n  b: color(xyz-d50 -0.1181465111 0.0299487833 3.363289424);\
         \n}\n"
        );
    }
}
#[test]
#[ignore] // unexepected error
fn white() {
    assert_eq!(
        runner().ok("@use \"sass:color\";\
             \na {b: color.to-space(color(rec2020 1 1 1), xyz-d50)}\n"),
        "a {\
         \n  b: color(xyz-d50 0.9642956764 1 0.8251046025);\
         \n}\n"
    );
}
