# ifndef _SKIT_PERMUTATION_H
# define _SKIT_PERMUTATION_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:permutation
NAME: @code{permutation} -- permutation matrix 
@clindex permutation
@clindex ssk
@clindex csr
@cindex Choleski factorization
@cindex skyline data structure
@cindex Gibbs renumbering
DESCRIPTION:       
 @noindent
 This class implements a permutation matrix.
 Permutation matrix are used in factorization
 implementation for optimizing the skyline format,
 as used by the implementation of the
 @code{ssk} class (@pxref{ssk class}).

 @noindent
 Let a be a square invertible matrix in @code{csr} format 
 (@pxref{csr class}):
 @example
     	csr<double> a;
 @end example

 @noindent
 We get the optimal Gibbs permutation matrix using
 Gibbs, Pooles and Stockmeyer renumbering algorithm by:
 @example
     permutation p = gibbs(a);
 @end example

AUTHOR: 
     Pierre Saramito
   | Pierre.Saramito@imag.fr
    LMC-IMAG, 38041 Grenoble cedex 9, France
DATE:   8 september 1997
METHODS: @permutation
End:
*/

namespace rheolef { 
template <class T> class csr;
}// namespace rheolef

# include "array.h"

namespace rheolef { 
//<permutation:
class permutation : public Array<std::vector<int>::size_type> {
public:

// typedefs:

    typedef Array<int>::size_type       size_type;
    typedef Array<int>::difference_type difference_type;

// allocators/deallocators:

    explicit permutation (size_type n = 0);
};
template<class T> 
permutation gibbs (const csr<T>& a);
//>permutation:

inline
permutation::permutation (size_type n)
 : Array<size_type>(n) 
{
}
}// namespace rheolef
# endif /* _SKIT_PERMUTATION_H */
