# Announce: Rakudo Perl 6 compiler, Release #116 (2017.10)

On behalf of the Rakudo development team, I’m very happy to announce the
October 2017 release of Rakudo Perl 6 #116. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.10:
 + SPECIAL NOTES:
    + This release includes fixes to || alternation in :ratchet
      mode. Code that was unintentionally relying on buggy behavior
      (backtracking in :ratchet mode) may now produce unwanted
      results (namely will fail to match) [963a0f06]
 + Security:
    + Restricted dynamic lookup metasyntax in rx EVAL [1d63dfd2][2448195d]
 + Deprecations:
    + Deprecated .new on native types [9d9c7f9c][cc6c0558]
    + Deprecated :buffer `open` arg in favor of :out-buffer [f9c10c21]
 + Fixes:
    + Fixed Hash.perl to include Scalar indicators [47d6c66e]
    + Fixed :delete with lazy Arrays [0385b2aa]
    + Fixed sanitization of on-demand Supplies [93a66d75]
    + Fixed duplicate done/quit messages [9e179355]
    + Fixed non-blocking `react { await blah() }` [29863a0b]
    + Fixed issues with Int.new [dff7d9b2][0d2ca0d7][0834036d]
    + Fixed isa method on a subset [cee1be22]
    + Fixed Supply.zip to eager-shift its values [f9400d9a]
    + Fixed two utf8-c8 bugs [963a0f06]
    + Fixed infinite loop in .^roles of a class that does Rational [0961abe8]
    + Changed uniname to give better strings for non-unique names [9dba498f]
    + Fixed .push-all/.skip-all on SlippyIterators [41896b7b]
    + Fixed and improved `**` regex quantifier [681d6be9][4ca1fc3c]
    + Made cmp-ok to try harder to give useful description [8479a1ba]
    + Made List.ACCEPTS non-fatal for lazy iterables [1b9638e2]
    + Fixed some unspace parsing cases [11070e0f]
    + Fixed &chdir failing to respect :CWD attribute [4906a1de]
    + Fixed Blob.gist to trim its guts to 100 elements [ac8e5f43]
    + Improved .perl and .gist methods on Maps and Hashes [aad8991e]
        [39461368][381c4c3b]
    + Fixed explosion in IO::CatHandle.nl-out [83008443]
    + Fixed .pick and .roll on object hashes [12fcece4]
    + Made cmp-ok take its arguments raw [3684384d]
    + Fixed `is default(Mu)` on attributes [54507ac9]
    + Made Array.List fill holes with Nil [e1351219]
    + Fixed BagHash.grab with large values [975fcf6c]
    + Fixed .tail with large values [43e7b893]
    + Improved .gist of nodal methods [b6982e68][bb1df2cb]
    + Fixed IO::Pipe.close not always returning the Proc [74328278]
    + Fixed handling of type objects in set operators [8a88d149]
    + Fixed location of errors coming from Channel [82a38c29]
    + Fixed lockup when scheduling with degenerate delays [df01ad97][031f8cf7]
    + Fixed segfault in getlexdyn [4f5fc520][4c370072]
    + Fixed poor error with some slurpies with defaults [a92950fb]
    + Fixed Int.new to properly give a new object [e4a5bb17]
    + Fixed .STORE leaving behind elements on native arrays [a85c8d48]
    + Various async improvements [633a15b8][ef4d16fe][f53d3963]
        [26a9c313][9d903408][0d600a0c][54783920][e0e5e6fa][b16aba01]
        [d8890a82][73aeee6c][2a826238][3deda842][f58ac999][40c2d0cd]
        [c46de00f][e5c17462][6e42b37e][80f883bc][6af44f8d][e70969e3]
        [30462d76][97b11edd]
    + Various fixes and improvements to hyper/race [cc2a0643][2352efe5]
        [d43b3738][dfa230f7][1fdc84fe][cef4806f][ea51d19b][374ee3e2]
        [ad0dd8e7][41729e93][d74ba041][83676112][2580a0a6][cf1673d9]
        [7e9b9633][870eaa31][d37a19ea][da977785][270e7c8a][ee3f0f4f]
        [a042fd92]
    + Various improvements to warnings and error reporting [38186fcd]
        [cf95ce81][66c2d05f][a845ac3d][48a84d6a][bb45791c][279bae08]
        [6542bb80][5747bc71][c7a82d45][fb7abf06][ac97a401][64b001a1]
        [1ea3297b][56eef696][25c87d0d][5d3ebc09][de2b9ff7][084078e1]
        [3acde358][b3bb8c40][e611978f][12774237][33e113a2][9554a97c]
 + Additions:
    + Improved .Capture semantics on all core types [4ba12ff1]
        [bad9fefd][cd5864cf]
    + Added trim* subroutines taking Cool instance [5a19dffa]
        [691f8b7b][e01e5bc3]
    + Added Lock::Async [53dd776c][4a8038c2][85bdd38a][38896402][6170cb9d]
    + Added atomic reference op support on JVM backend [32e4a1de][59c4117f]
    + Added $*USAGE [0b15f672]
    + Added :bin parameter to IO::Handle.slurp [e2ec569b]
    + Added support for Bufs in &EVAL/&EVALFILE [6c928d61]
    + Added warning on typical precedence errors with infix:<..> [26bdc95c]
    + Added --repl-mode command line option [9ce896d8][20518454]
        [5c7bbea0][93e599db][de0533c4]
    + Implemented typed pointer increment and array dereference
        [3ca6554f][bc5fbfcb][2fba0ba0]
    + Added X::Numeric::CannotConvert exception type [2e726528]
        [b377de1c][f04bd1d6]
    + Added IO::Handle.out-buffer for controlling the buffer size
        [f9c10c21][765dd694]
    + Added IO::Path.parent(Int) for getting up more than one level
        [7bea3a2d][78d8d509]
 + Removals:
    + Removed $*MAIN-ALLOW-NAMED-ANYWHERE [9cb4b167]
    + Removed support for ornate parenthesis from quoting constructs [9ce896d8]
    + Renamed $*INITTIME to $*INIT-INSTANT according to the spec
        [6bdb2dd3][bd6c6403]
 + Build system:
    + Reworked REPL tests [be4d57de][338a0972][7c8a2739][f8edb829][1ce3a36d]
    + Various changes related to v6.d prep [7d830d5c][6cb810d2][36bc8e2d]
        [31cbdada][16f64182][50d2013d][f62950dc][dd8a6102]
        [36122f15][2a512f0c][03b1febc][edce8f53][c6ff787a]
 + Efficiency:
    + Made startup time up to 5 ms faster [48406db6][a09f5f21][bb5583ae]
    + Made chained ops up to 36x faster [a92d0369]
    + Made ≥, ≤, and ≠ unicode ops as fast as ascii equivalents
        [6ec21cb4][1af2a745][43c348a8][9ff2f98f][6ad06fad]
    + Made &infix:<cmp> with Version:Ds 7.2x faster [1d9553f0]
    + Made &DEPRECATED 27% faster when vfrom is too large [145e3156]
    + Made Blob.gist 26x faster [20a99fc3]
    + Made Hash.gist 24% faster [69af24c4]
    + Made @a[42..*] 4.2x faster [456358e3]
    + Various NativeCall speedups [a06ebaf2][269fe7db][80d6b425]
    + Significantly faster interpolation of variables into regexes
        [1761540e][0a68a18f][d73d500b][1775259a][e8003c87]
        [4d3ccd83][04b171bd][317ae16c][dd880cad][2262cc47]
    + Other small optimizations [9d4a833b][6902c590][fb4eb666]
        [b9c98531][4fae0711][921db910][c91c4011][98fae3d8]
        [a462d0a2][16c2a157][5f6896bd][397692ac][476741e7]
 + Internal:
    + New JIT [2724a851][ff063e7b]
    + Better scheduler [d2eb7423][80b49320][340d8ed3][c50d35a9][9af5607d]
        [683037be][7c18112c][c285b489][b5605c2d][3b98fb9e][596611c8]
        [6f6e62ea][176a6fae][43b7cfde][59bfa5ab][27590e8b][e95eb42c]
        [2c4868b8]
    + Added RAKUDO_SCHEDULER_DEBUG_STATUS env var [de311f46]
    + Bumped libuv to the latest version [198b8497]
    + Reworked BUILDALL method autogeneration [9837687d][63cf246f]
        [5ad2fffe][31a03a41][eb9c3d4d][346dfeff][70ca505a][af2ab751]
        [5cd9197f][6824e192][7363f898][4959df3f][dd943ede][d3c48185]
        [371befe8][4d0ead24][92f239b5][7fa707db][d76af6aa][e513b857]
        [f80a8461][fcbd8adb][21788c89][e2f8a57d][b58bd8fb][0dd6af71]
        [f946bd35][cef3bf3e][92e51c3d][5144216f][ebd6440c]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Pawel Murias, Jonathan Worthington,
Aleks-Daniel Jakimenko-Aleksejev, Will "Coke" Coleda, Tom Browder,
Christian Bartolomäus, Samantha McVey, Daniel Green, Steve Mynott,
Patrick Spek, Stefan Seifert, Luca Ferrari, Brian S. Julin,
Rafael Schipiura, Timo Paulssen, Alex Chen, David Warring, Cuong Manh Le,
Naoum Hankache, Alex Wander, Nick Logan, Wenzel P. P. Peppmeyer, 陈梓立,
Jeremy Studer, Brian Duggan, Larry Wall, Jan-Olof Hendig, Jonathan Stowe,
Christopher Bottoms, Itsuki Toyota, Dan Zwell, Philippe Bruhat (BooK), gerd,
lefth, Viacheslav Lotsmanov, Robert Lemmen, Shlomi Fish, Altai-man,
Jarkko Haapalainen

as well as

Bart Wiegmans, Jimmy Zhuo, Joel, Julien Simonet, Justin DeVuyst, M, Mario, Martin Ryan, Moritz Lenz, Patrick Sebastian Zimmermann, Paweł Murias, bitrauser, coypoop, eater, mryan, smls

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#117), is tentatively scheduled for 2017-11-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
