# Announce: Rakudo Perl 6 compiler, Release #105 (2016.11)

On behalf of the Rakudo development team, I’m very happy to announce the
November 2016 release of Rakudo Perl 6 #105. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2016.11:
 + Fixes:
    + Various improvements to warning/error-reporting
    + Fixed assigning values to shaped arrays through iterators [839c762]
    + Fixed Str.Int not failing on numerics with combining characters [d540fc8]
    + [JVM] Fixed <a b c>.antipairs breakage [dd7b055]
    + defined routine now correctly authothreads with Junctions [189cb23]
    + Fixed poor randomness when .pick()ing on ranges with >32-bit numbers [34e515d]
    + Fixed infix:<x> silencing Failures [2dd0ddb]
    + Fixed edge case in is-approx that triggers DivByZero exception [f7770ed]
    + (Windows) Fixed returning of an error even when succeeding in mkdir [208a4c2]
    + (Windows) Fixed precomp unable to rename a newly compiled file [44a4c75]
    + (Test.pm) Fixed indent of multi-line diag() and test failure messages [43dbc96]
    + Fixed a callframe crash due to boxing of NULL filenames [200364a]
    + ∞ ≅ ∞ now gives True [4f3681b]
    + Fixed oversharing with grammars used by multiple threads [7a456ff]
    + Fixed incorrect calculations performed by acotan(num) [8e9fd0a]
    + Fixed incorrect calculations performed by asinh(num)/acosh(num) [a7e801f]
    + Fixed acosh return values for large negative numbers [5fe8cf7]
    + asinh(-∞) now returns -∞ instead of NaN [74d0e36]
    + atanh(1) now returns ∞ instead of throwing [906719c][66726e8]
    + Fixed missing close in IO::Path.slurp(:bin) [697a0ae]
    + :U QuantHashes now auto-vivify to their correct type and not Hash [79bb867]
    + Mix/MixHash.Bag/BagHash coersion now ignores negative weights [87bba04]
    + arity-0 infix:<Z> now returns a Seq instead of a List [3fdae43]
    + Fix augment of a nested package [87880ca]
    + Smartmatch with Regex variable now returns a Match instead of Bool [5ac593e]
    + Empty ()[0] now returns Nil instead of False [f50e39b]
    + Failed IO::Socket::Async connection no longer produces unexpected crash [f50e39b]
    + Quitting Supplies with no QUIT phasers no longer unexpectedly crash [f50e39b]
    + Fixed NativeCall issues on big endian machines [627a77e]
    + Fixed broken handling of $/ in some uses of `.match` [ba152bd]
    + Fixed Lock.protect not releasing the lock on control exceptions [48c2af6]
    + MoarVM now builds on any version of macOS [b4dfed2]
    + Fixed concurrency crashes due to garbage collection [6dc5074]
    + Fixed race condition in EmptyIterator [ed2631c]
    + Fixed hang with multi-threaded long-running NativeCall calls [f99d958]
    + Made my @a[10] = ^Inf work [aedb8e7]
    + Fixed [;]:delete [3b9c4c9]
    + Fixed incorrect handling of negative weights in ∪ operator [e10f767]
    + duckmap now preserves types of Iterables [43cb55f]
    + Fixed premature overflow to Inf with large Num literals [729d7e3]
    + Fixed race condition in NativeCall callsite used by multiple threads [49fd825]
    + Fixed instabilities in programs launching many threads at startup [0134132]
    + Fixed crash when reporting X::Composition::NotComposable or
        X::Inheritance::Unsupported exceptions [a822bcf]
    + Fixed clock_gettime issue on macOS [ee8ae92]
    + Fixed SEGV in multi-threaded programs with strings-as-strands [395f369]
    + `regex` TOP Grammar rule will now backtrack if needed [4ccb2f3]
    + Fixed .rotate/.reverse on 1-dimmed arrays assigning to self [2d56751]
    + Fixed exponentiation involving zeros for Complex numbers [7f32243]
    + Fixed Label.gist [29db214][53d7b72]
    + Fixed certain edge cases of incorrect stringification of Rationals
        with .Str, .perl, and .base [b5aa3c5]
 + Additions:
    + Added TWEAK submethod for object construction [fdc90a2][9409d68]
    + Added DateTime.hh-mm-ss [bf51eca]
    + Added parse-base routine [7e21a24]
    + is-approx with no explicit tolerances now uses more complex algorithm to
        choose a tolerance to use (same as old is_approx) [82432a4]
    + on failure, is-approx now displays actual values received [b4fe680]
    + Added Iterator.skip-one to skip a single value [71a01e9]
    + Added Iterator.skip-at-least to skip several values [8d357af]
    + Re-imagined Str.match [b7201a8]:
        + the family of :nth is now lazy will return whatever can find
        + non-monotonically increasing :nth iterator values will now die
    + Str.match/subst/subst-mutate now have :as adverb [1b95636][c9a24d9][aaec517]
    + &infix:<eqv> now works with Setty objects [d92e1ad]
    + :ov and :ex adverbs are now illegal in Str.subst [b90c741]
    + Made nextwith/samewith/nextsame/callwith to be real subroutines [70a367d]
    + Added CX::Emit and CX::Done control exceptions [07eeea8]
    + Setty.Mix/.MixHash coercers now use Int weights instead of Bool [7ba7eb4]
    + Implemented :kv,:p,:k,:v on 1-element multidim [;] [764cfcd]
    + .chrs can now also accepts codepoint numbers as Str [4ae3f23]
    + Added support for compilation of Rakudo on Solaris [a43b0c1]
    + IterationEnd.perl/gist/Str now returns text "IterationEnd" [59bb1b1]
    + Added X::Syntax::Number::InvalidCharacter exception [2faa55b]
    + .reverse/rotate on 1-dimmed arrays are now nodal [cd765e6]
    + .line and .file on core Code now references original source files [b068e3a]
    + .rethrow now works on unthrown exceptions [58a4826]
    + All Reals now accept `Whatever` as the second argument to .base() [c1d2599]
    + sub MAIN usage message shows possible Enum values if param is
        named and is an Enum [a3be654]
 + Efficiency:
    + Made slip(@a) about 1.2x faster [37d0e46]
    + Made initialization of 2+dimmed array 10x to 16x faster [dfb58d4]
    + Str.match is now about 5% faster [4fc17df]
    + Str.match with :nth feature is now about 2x faster [41e2572]
    + my @a = Str.match(...) is now about 5% faster [e472420]
    + Str.comb(Regex) is now about 7x faster [1794328]
    + Simple Str.subst/subst-mutate is now about 30% faster [364e67b]
    + Match.Str|prematch|postmatch is now about 2x faster [e65d931]
    + Match.Bool is now about 1% faster (not much, but used a lot) [1fce095]
    + Made ~~ /foo/ faster: 2% for successful/6% for failed matches [05b65d0]
    + Made <foo bar baz> ~~ /foo/ about 2x faster [e4dc8b6]
    + Made %h ~~ /foo/ about 2x faster [33eeb32]
    + Frequent accesses of multiple adverbs (e.g. %h<a>:p:exists)
        is now 2x faster [f22f894]
    + Made infix:<eqv> faster: Str: 14x, type: 10x, Range: 3.5x,
        Int|Seq|Hash: 1.5x, Array: 1.2x [bc7fcc6]
    + IO::Spec::Unix.canonpath is now 7x to 50x faster [f3f00fb]
    + Baggy.roll/pick is now about 10% faster [fc47bbf]
    + Made copying shaped arrays 10x to 20x faster [a1d8e93][0cf7b36][d27ecfa]
    + Made setting up a shaped array 2x as fast [f06e4c3]
    + Made creation of typed shaped arrays 15% faster [f5bf6c1]
    + Made 2d/3d array accesses about 7x as fast [d3a0907]
    + Made AT-POS on 1,2,3dim arrays about 20x faster [feb7bcb]
    + Made creating a shaped array about 50% faster [1293188][576f3a1]
    + Made .AT-POS on 3+ dimmed arrays 20% faster [1bb5aad]
    + Made over-indexed .AT-POS on 1,2,3 dimmed arrays about 10% faster [1bb5aad]
    + Made multi-dimmed ASSIGN-POS about 30% faster [5b2bdeb]
    + Made .ASSIGN-POS for 1,2,3dimmed arrays about 40x faster [050cf72]
    + Made n-dimmed .EXISTS-POS about 1.5x faster [006f008]
    + Made .EXISTS-POS for 1,2,3dimmed arrays about 10x faster [b1c41b7]
    + Made n-dimmed DELETE-POS about 1.3x faster [6ccecb1]
    + Made .DELETE-POS for 1,2,3dimmed arrays about 20x faster [55b9e90]
    + Made n-dimmed BIND-POS about 1.3x faster [2827edb]
    + Made .BIND-POS for 1,2,3dimmed arrays about 20x faster [9f94525]
    + Made @a[10].STORE at least as fast as @a.STORE [8064ff1]
    + Made .kv on shaped Arrays about 4x faster [e42b68e]
    + Made .pairs/.antipairs on shaped Arrays about 2.8x faster [0f2566a][f608a33]
    + Made List.kv about 30% faster [7a2baf4]
    + for loops on 1-dimmed arrays are now 3x faster [ed36e60]
    + .kv on 1-dimmed arrays is now 7x faster [608de26]
    + .pairs/.antipairs on 1-dimmed arrays is now 3x faster [b7d9537][1c425f9]
    + postcircumfix[;] on 2/3 dimmed arrays is now 9x faster [0b97362]
    + Assignment to [;] for 2/3 dimmed arrays is now 10x faster [ce85ba3]
    + [;]:exists for 2/3 dimmed arrays is now 7x faster [e3e3fef]
    + [;]:delete for 2/3 dimmed arrays is now 10x faster [3b9c4c9]
    + [;] := foo for 2/3 dimmed arrays is now 10x faster [eaf4132]
    + .iterator and .values on shaped arrays are now about 4x faster [736ab11]
    + Fixed optimization of shaped arrays that gives 10% gain on simple `for`
        loops and likely will give larger gains on bigger programs [b7e632e]
    + Made starting MappyIterator faster, affecting all Hash/Map/Baggy iterator
        methods. 2-elem Hash iteration is 1.6x faster [97fb6c2]
    + Made starting a grepper faster: .grep on with no adverbs on 2-element list
        is now 20% faster [077c8f0]
    + Made Date/DateTime creation 20% faster [0e7f480]
    + Hashes now use 4 (32-bit) or 8 (64-bit) bytes less memory per stored item  [395f369]
    + Rational.Str is now about 40% faster [b5aa3c5]
    + Rational.base is now about 30% faster [b5aa3c5]
    + Various streamlining of code that's hard to measure the final impact of


The following people contributed to this release:

Elizabeth Mattijsen, Zoffix Znet, Will "Coke" Coleda, Pawel Murias, 
Jonathan Worthington, Wenzel P. P. Peppmeyer, Christian Bartolomäus, 
Daniel Green, Tom Browder, Will Coleda, Timo Paulssen, Tobias Leich, 
Jan-Olof Hendig, cpin, adaptiveoptics, Francis Grizzly Smit, Brock Wilcox, 
Moritz Lenz, seatek, Altai-man, ab5tract, Stefan Seifert, 
Aleks-Daniel Jakimenko-Aleksejev, Sterling Hanenkamp, Vynce Montgomery, 
David Warring, Athos Ribeiro, Paul Cochrane, Samantha McVey, 
Geoffrey Broadwell, Jonathan Stowe, Nic, Vladimir Marek, Larry Wall, 
Garrett Goebel, Pepe Schwarz, raiph, bazzaar, Clifton Wood, Carl Masak, 
Dominique Dumont, samcv, David H. Adler, José Albert Cruz Almaguer, 
Harrison Chienjo

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#106), is tentatively scheduled for 2016-12-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.

