% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.time.R
\name{is.index.unique}
\alias{is.index.unique}
\alias{is.time.unique}
\alias{make.index.unique}
\alias{make.time.unique}
\title{Force Time Values To Be Unique}
\usage{
is.index.unique(x)

is.time.unique(x)

make.index.unique(x, eps = 1e-06, drop = FALSE, fromLast = FALSE, ...)

make.time.unique(x, eps = 1e-06, drop = FALSE, fromLast = FALSE, ...)
}
\arguments{
\item{x}{An xts object, or POSIXct vector.}

\item{eps}{A value to add to force uniqueness.}

\item{drop}{Should duplicates be dropped instead of adjusted by \code{eps}?}

\item{fromLast}{When \code{drop = TRUE}, \code{fromLast} controls which duplicated
times are dropped. When \code{fromLast = FALSE}, the earliest observation with
an identical timestamp is kept and subsequent observations are dropped.}

\item{\dots}{Unused.}
}
\value{
A modified version of \code{x} with unique timestamps.
}
\description{
A generic function to force sorted time vectors to be unique. Useful for
high-frequency time-series where original time-stamps may have identical
values. For the case of xts objects, the default \code{eps} is set to ten
microseconds. In practice this advances each subsequent identical time by
\code{eps} over the previous (possibly also advanced) value.
}
\details{
The returned time-series object will have new time-stamps so that
\code{isOrdered(.index(x))} evaluates to \code{TRUE}.
}
\note{
Incoming values must be pre-sorted, and no check is done to make sure
that this is the case.  \sQuote{integer} index value will be coerced to
\sQuote{double} when \code{drop = FALSE}.
}
\examples{

ds <- options(digits.secs=6) # so we can see the change

x <- xts(1:10, as.POSIXct("2011-01-21") + c(1,1,1,2:8)/1e3)
x
make.index.unique(x)

options(ds)

}
\seealso{
\code{\link[=align.time]{align.time()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{ts}
