% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{missing}
\alias{missing}
\alias{vec_detect_missing}
\alias{vec_any_missing}
\title{Missing values}
\usage{
vec_detect_missing(x)

vec_any_missing(x)
}
\arguments{
\item{x}{A vector}
}
\value{
\itemize{
\item \code{vec_detect_missing()} returns a logical vector the same size as \code{x}.
\item \code{vec_any_missing()} returns a single \code{TRUE} or \code{FALSE}.
}
}
\description{
\itemize{
\item \code{vec_detect_missing()} returns a logical vector the same size as \code{x}. For
each element of \code{x}, it returns \code{TRUE} if the element is missing, and \code{FALSE}
otherwise.
\item \code{vec_any_missing()} returns a single \code{TRUE} or \code{FALSE} depending on whether
or not \code{x} has \emph{any} missing values.
}
\subsection{Differences with \code{\link[=is.na]{is.na()}}}{

Data frame rows are only considered missing if every element in the row is
missing. Similarly, \link[=new_rcrd]{record vector} elements are only considered
missing if every field in the record is missing. Put another way, rows with
\emph{any} missing values are considered \link[=vec_detect_complete]{incomplete}, but
only rows with \emph{all} missing values are considered missing.

List elements are only considered missing if they are \code{NULL}.
}
}
\section{Dependencies}{

\itemize{
\item \code{\link[=vec_proxy_equal]{vec_proxy_equal()}}
}
}

\examples{
x <- c(1, 2, NA, 4, NA)

vec_detect_missing(x)
vec_any_missing(x)

# Data frames are iterated over rowwise, and only report a row as missing
# if every element of that row is missing. If a row is only partially
# missing, it is said to be incomplete, but not missing.
y <- c("a", "b", NA, "d", "e")
df <- data_frame(x = x, y = y)

df$missing <- vec_detect_missing(df)
df$incomplete <- !vec_detect_complete(df)
df
}
\seealso{
\code{\link[=vec_detect_complete]{vec_detect_complete()}}
}
