% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgMan.R
\name{pkgman_describe}
\alias{pkgman_describe}
\alias{pkgman_get_mirrors}
\alias{pkgman_get_available}
\alias{pkgman_get_installed}
\alias{pkgman_set_cran_mirror}
\alias{pkgman_install}
\alias{pkgman_remove}
\alias{pkgman_load}
\alias{pkgman_detach}
\alias{pkgManDescribe}
\alias{pkgManGetMirrors}
\alias{pkgManGetAvailable}
\alias{pkgManGetInstalled}
\alias{pkgManSetCRANMirror}
\alias{pkgManInstall}
\alias{pkgManRemove}
\alias{pkgManLoad}
\alias{pkgManDetach}
\title{Functions to manage R side of the SciViews R package manager}
\usage{
pkgman_describe(pkgname, print.it = TRUE)

pkgman_get_mirrors()

pkgman_get_available(
  page = "next",
  pattern = "",
  n = 50,
  keep = c("Package", "Version", "InstalledVersion", "Status"),
  reload = FALSE,
  sep = ";",
  eol = "\\t\\n"
)

pkgman_get_installed(sep = ";", eol = "\\t\\n")

pkgman_set_cran_mirror(url)

pkgman_install(pkgs, install.deps = FALSE, ask = TRUE)

pkgman_remove(pkgname)

pkgman_load(pkgname)

pkgman_detach(pkgname)

pkgManDescribe(pkgname, print.it = TRUE)

pkgManGetMirrors()

pkgManGetAvailable(
  page = "next",
  pattern = "",
  n = 50,
  keep = c("Package", "Version", "InstalledVersion", "Status"),
  reload = FALSE,
  sep = ";",
  eol = "\\t\\n"
)

pkgManGetInstalled(sep = ";", eol = "\\t\\n")

pkgManSetCRANMirror(url)

pkgManInstall(pkgs, install.deps = FALSE, ask = TRUE)

pkgManRemove(pkgname)

pkgManLoad(pkgname)

pkgManDetach(pkgname)
}
\arguments{
\item{pkgname}{The name of one R package (character string).}

\item{print.it}{Should the result be printed?}

\item{page}{Which page to get?}

\item{pattern}{Selection pattern.}

\item{n}{The number of items to retrieve.}

\item{keep}{The columns to keep in the resulting data frame.}

\item{reload}{Do we force reload of the data and ignore cache version?}

\item{sep}{Field separator to use.}

\item{eol}{End-of-line sequence to use.}

\item{url}{The URL to use for the current CRAN mirror.}

\item{pkgs}{A list of packages to install.}

\item{install.deps}{Do we also install dependencies?}

\item{ask}{Do we prompt the user for package installation?}
}
\value{
These functions return data that is intended to be used by the
SciViews \R package manager.
}
\description{
These functions should not be used directly by the end-user.
They implement the R-side code for the SciViews \R package manager.
}
\seealso{
\code{\link[=package]{package()}}
}
\author{
Kamil Barton \href{mailto:kamil.barton@uni-wuerzburg.de}{kamil.barton@uni-wuerzburg.de}
}
\concept{SciViews R package manager}
\keyword{utilities}
