% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statcheck.R
\name{summary.statcheck}
\alias{summary.statcheck}
\title{Summary method for statcheck}
\usage{
\method{summary}{statcheck}(object, ...)
}
\arguments{
\item{object}{a \code{statcheck} object.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A data frame containing for each source of statistics:
\describe{
    \item{source}{Name of the file/origin of which the statistics are 
    extracted}
    \item{nr_p_values}{The number of extracted reported p values per article}
    \item{nr_errors}{The number of errors per article}
    \item{nr_decision_errors}{The number of decision errors per article}
}
}
\description{
Gives the summaries for a \code{statcheck} object.
}
\examples{
txt <- "blablabla the effect was very significant (t(100)=1, p < 0.001)"
stat <- statcheck(txt)
summary(stat)

}
