%  file sn/man/SECdistrUv-class.Rd  
%  This file is a component of the package 'sn' for R
%  copyright (C) 2013 Adelchi Azzalini
%---------------------
\name{SECdistrUv-class}
\Rdversion{1.1}
\docType{class}
\alias{SECdistrUv-class}
\alias{show,SECdistrUv-method}
\alias{mean,SECdistrUv-method}
\alias{sd,SECdistrUv-method}


\title{Class \code{"SECdistrUv"}}

\description{A class of objects representing univariate skew-elliptically
  contoured (\acronym{SEC}) distributions.}

\section{Objects from the class}{
Objects can be created by a call to function \code{\link{makeSECdistr}} 
when its argument \code{dp} is a vector. They can also obtained from
an object generated by \code{selm} using the function \code{extractSEDdistr}.
}

\section{Slots}{
  \describe{
    \item{\code{family}:}{a character string which selects the parametric
       family; currently, possible values are: \kbd{"SN"}, \kbd{"ESN"}, 
       \kbd{"ST"}, \kbd{"SC"}. }
    \item{\code{dp}:}{a numeric vector of parameters; its length depends 
       on the selected \code{family}.}
    \item{\code{name}:}{a character string with name of the distribution.}
  }
}

\section{Methods}{
  \describe{   
    \item{show}{\code{signature(object = "SECdistrUv")}: \dots}
    \item{plot}{\code{signature(x = "SECdistrUv")}: \dots }
    \item{summary}{\code{signature(object = "SECdistrUv")}: \dots}
    \item{mean}{\code{signature(x = "SECdistrUv")}: \dots}
    \item{sd}{\code{signature(object = "SECdistrUv")}: \dots}
    }
}

\author{Adelchi Azzalini}

\note{
  See \code{\link{makeSECdistr}} for a detailed description of \code{family} 
  and \code{dp}. 

  Unlike various other packages, methods \code{mean} and \code{sd} here are 
  not targeted to data or to a fitted model, but to a \emph{probability
  distribution} instead, of which they provide the mean value
  and the standard deviation.   If these methods  are applied
  to a distribution of which the mean or the variance do not exist, 
  a \code{NULL} value is returned and a warning message is issued.

  }

\seealso{
  \code{\linkS4class{SECdistrMv}},
  \code{\link{plot,SECdistrUv-method}}, 
  \code{\link{summary,SECdistrUv-method}},
  \code{\link{extractSECdistr}}
}


\examples{
f2 <- makeSECdistr(dp=c(3, 5, -pi, 6), family="ST", name="My first ST")
show(f2)
plot(f2)
plot(f2, probs=c(1,5,9)/10)
plot(f2, range=c(-30,10), probs=NULL, col=2, main=NULL)
summary(f2)
mean(f2)  # the mean value of the probability distribution
sd(f2)  # the standard deviation of the distribution  
}
\keyword{classes}
