% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sitmo_parallel}
\alias{sitmo_parallel}
\title{Test Generation using sitmo and C++11}
\usage{
sitmo_parallel(n, seeds)
}
\arguments{
\item{n}{An \code{unsigned integer} denoting the number of realizations to generate.}

\item{seeds}{A \code{vec} containing a list of seeds. Each seed is run on its own core.}
}
\value{
A \code{vec} containing the realizations.
}
\description{
The function provides an implementation of creating realizations from the default engine.
}
\details{
The following function's true power is only accessible on platforms that support OpenMP (e.g. Windows and Linux).
However, it does provide a very good example as to how to make ones code applicable across multiple platforms.

With this being said, how we determine how many cores to split the generation to is governed by the number of seeds supplied.
In the event that one is using OS X, only the first seed supplied is used.
}
\examples{
a = sitmo_parallel(10, c(1))

b = sitmo_parallel(10, c(1,2))

c = sitmo_parallel(10, c(1,2))

# True on only OS X or systems without openmp
isTRUE(all.equal(a,b))

isTRUE(all.equal(b,c))
}
