% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group2NA.R
\name{group2NA}
\alias{group2NA}
\title{Separate groups with missing values}
\usage{
group2NA(
  data,
  groupNames = "group",
  nested = NULL,
  ordered = NULL,
  retrace.first = inherits(data, "GeomPolygon")
)
}
\arguments{
\item{data}{a data frame.}

\item{groupNames}{character vector of grouping variable(s)}

\item{nested}{other variables that group should be nested
(i.e., ordered) within.}

\item{ordered}{a variable to arrange by (within nested & groupNames). This
is useful primarily for ordering by x}

\item{retrace.first}{should the first row of each group be appended to the
last row? This is useful for enclosing polygons with lines.}
}
\value{
a data.frame with rows ordered by: \code{nested},
then \code{groupNames}, then \code{ordered}. As long as \code{groupNames}
contains valid variable names, new rows will also be inserted to separate
the groups.
}
\description{
This function is used internally by plotly, but may also be useful to some
power users. The details section explains when and why this function is useful.
}
\details{
If a group of scatter traces share the same non-positional characteristics
(i.e., color, fill, etc), it is more efficient to draw them as a single trace
with missing values that separate the groups (instead of multiple traces),
In this case, one should also take care to make sure
\href{https://plot.ly/r/reference/#scatter-connectgaps}{connectgaps}
is set to \code{FALSE}.
}
\examples{

# note the insertion of new rows with missing values 
group2NA(mtcars, "vs", "cyl")

# need to group lines by city somehow!
plot_ly(txhousing, x = ~date, y = ~median) \%>\% add_lines()

# instead of using group_by(), you could use group2NA()
tx <- group2NA(txhousing, "city")
plot_ly(tx, x = ~date, y = ~median) \%>\% add_lines()

# add_lines() will ensure paths are sorted by x, but this is equivalent
tx <- group2NA(txhousing, "city", ordered = "date")
plot_ly(tx, x = ~date, y = ~median) \%>\% add_paths()

}
