% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_that.R
\name{assert_that}
\alias{assert_that}
\title{Scoped Assertions}
\usage{
assert_that(
  ...,
  env = parent.frame(),
  msg = NULL,
  scope = find_scope(env),
  type = "assertion failure"
)
}
\arguments{
\item{...}{unnamed expressions that describe the conditions to be tested.
Rather than combining expressions with \code{&&}, separate them by commas
so that better error messages can be generated.}

\item{env}{(advanced use only) the environment in which to evaluate the
assertions.}

\item{msg}{a custom error message to be printed if one of the conditions is
false.}

\item{scope}{The scope of the error.}

\item{type}{The error type.}
}
\description{
The pkgcond package intentionally overrides the \code{\link[assertthat:assert_that]{assertthat::assert_that()}}
function.  It provides the same utility but enhances the original version
by throwing scoped and typed errors.  The type is 'assertion failure' and
the scope can be set or inferred from the calling frame.
}
