% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transferBootstrap.R
\name{transferBootstrap}
\alias{transferBootstrap}
\title{Transfer Bootstrap}
\usage{
transferBootstrap(tree, trees, phylo = TRUE, scale = TRUE)
}
\arguments{
\item{tree}{The tree on which edges the bootstrap values are plotted.}

\item{trees}{a list of trees (object of class "multiPhylo").}

\item{phylo}{Logical, return a phylogentic tree with support value or a
vector of bootstrap values.}

\item{scale}{scale the values.}
}
\value{
a phylogentic tree (a phylo object) with bootstrap values assigned to
the node labels.
}
\description{
\code{transferBootstrap} assigns transfer bootstrap (Lemoine et al. 2018)
values to the (internal) edges.
}
\examples{
fdir <- system.file("extdata/trees", package = "phangorn")
# RAxML best-known tree with bipartition support (from previous analysis)
raxml.tree <- read.tree(file.path(fdir,"RAxML_bipartitions.woodmouse"))
# RAxML bootstrap trees (from previous analysis)
raxml.bootstrap <- read.tree(file.path(fdir,"RAxML_bootstrap.woodmouse"))

tree_tbe <- transferBootstrap(raxml.tree,  raxml.bootstrap)
par(mfrow=c(1,2))
plotBS(tree_tbe)
# same as
plotBS(raxml.tree,  raxml.bootstrap, "p", "TBE")
}
\references{
Lemoine, F., Entfellner, J. B. D., Wilkinson, E., Correia, D.,
Felipe, M. D., De Oliveira, T., & Gascuel, O. (2018). Renewing Felsenstein’s
phylogenetic bootstrap in the era of big data. \emph{Nature},
\bold{556(7702)}, 452--456.
}
\seealso{
\code{\link{plotBS}}, \code{\link{maxCladeCred}},
\code{\link[ape]{drawSupportOnEdges}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
