% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{km}
\alias{km}
\title{Kaplan-Meier with robust standard errors}
\usage{
km(formula, data = data, conf.type = "log", conf.int = 0.95,
  robust = TRUE, ...)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph})}

\item{data}{data frame}

\item{conf.type}{transformation}

\item{conf.int}{level of confidence intervals}

\item{robust}{for robust standard errors based on martingales}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Kaplan-Meier with robust standard errors 
Robust variance is default variance with the summary.
}
\examples{
data(TRACE)
TRACE$cluster <- sample(1:100,1878,replace=TRUE)
out1 <- km(Surv(time,status==9)~strata(vf,chf),data=TRACE)
out2 <- km(Surv(time,status==9)~strata(vf,chf)+cluster(cluster),data=TRACE)

par(mfrow=c(1,2))
bplot(out1,se=TRUE)
bplot(out2,se=TRUE)
}
\author{
Thomas Scheike
}
